/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.pack.custom.PackSettings;
import com.ssomar.score.pack.spigot.InjectSpigot;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class PackManager {
    private Map<UUID, PackSettings> packs = new HashMap<UUID, PackSettings>();
    private static PackManager instance;

    private PackManager() {
    }

    public void addPack(PackSettings pack) {
        File actualPackFile;
        File cacheFolder = new File(SCore.dataFolder, "textures-cache");
        if (!cacheFolder.exists()) {
            cacheFolder.mkdirs();
        }
        if (!(actualPackFile = pack.getFile()).exists()) {
            return;
        }
        File cachePackFile = new File(cacheFolder, actualPackFile.getName());
        if (cachePackFile.exists()) {
            cachePackFile.delete();
        }
        try {
            FileUtils.copyFile((File)actualPackFile, (File)cachePackFile);
            pack.setFilePath(cachePackFile.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pack.isDeleteInitialFile()) {
            actualPackFile.delete();
        }
        this.packs.put(pack.getUuid(), pack);
        InjectSpigot.INSTANCE.registerInjector(pack.getInjector());
        for (Player player : Bukkit.getServer().getOnlinePlayers()) {
            try {
                player.addResourcePack(pack.getUuid(), pack.getHostedPath(), null, pack.getCustomPromptMessage(), pack.isForce());
            }
            catch (Error | Exception throwable) {}
        }
    }

    public void removePack(UUID uuid) {
        PackSettings pack = this.packs.get(uuid);
        if (pack != null) {
            this.packs.remove(uuid);
            InjectSpigot.INSTANCE.unregisterInjector(pack.getInjector());
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                try {
                    player.removeResourcePack(uuid);
                }
                catch (Error | Exception throwable) {}
            }
        }
    }

    public void removeAllPacks() {
        for (PackSettings pack : this.packs.values()) {
            InjectSpigot.INSTANCE.unregisterInjector(pack.getInjector());
            for (Player player : Bukkit.getServer().getOnlinePlayers()) {
                try {
                    player.removeResourcePack(pack.getUuid());
                }
                catch (Error | Exception throwable) {}
            }
        }
        this.packs.clear();
    }

    public static PackManager getInstance() {
        if (instance == null) {
            instance = new PackManager();
        }
        return instance;
    }

    @Generated
    public Map<UUID, PackSettings> getPacks() {
        return this.packs;
    }
}

