/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.safebreak;

import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.executableblocks.executableblocks.placedblocks.ExecutableBlockPlaced;
import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.events.BlockBreakEventExtension;
import com.ssomar.score.usedapi.BentoBoxAPI;
import com.ssomar.score.usedapi.ExcellentClaimsAPI;
import com.ssomar.score.usedapi.FactionsUUIDAPI;
import com.ssomar.score.usedapi.GriefPreventionAPI;
import com.ssomar.score.usedapi.IridiumSkyblockTool;
import com.ssomar.score.usedapi.ItemsAdderAPI;
import com.ssomar.score.usedapi.LandsIntegrationAPI;
import com.ssomar.score.usedapi.ProtectionStonesAPI;
import com.ssomar.score.usedapi.ResidenceAPI;
import com.ssomar.score.usedapi.SuperiorSkyblockTool;
import com.ssomar.score.usedapi.TownyToolAPI;
import com.ssomar.score.usedapi.WorldGuardAPI;
import dev.rosewood.roseloot.RoseLoot;
import dev.rosewood.roseloot.loot.LootResult;
import dev.rosewood.roseloot.loot.context.LootContext;
import dev.rosewood.roseloot.loot.context.LootContextParams;
import dev.rosewood.roseloot.loot.table.LootTableTypes;
import dev.rosewood.roseloot.manager.LootTableManager;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.Bisected;
import org.bukkit.block.data.type.Door;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SafeBreak {
    private static final boolean DEBUG = true;

    public static boolean breakBlockWithEvent(Block block, @Nullable UUID playerUUID, int slot, boolean drop, boolean generateBreakEvent, boolean verifSafeBreak, BlockBreakEventExtension.BreakCause breakCause) {
        SsomarDev.testMsg(ChatColor.GOLD + "[#s0010] breakBlockWithEvent() trigger from SafeBreak.java", true);
        if (playerUUID == null) {
            SsomarDev.testMsg("[#s0013] Player is null", true);
            if (SafeBreak.breakEB(null, block, drop)) {
                return true;
            }
            block.breakNaturally();
            return true;
        }
        SsomarDev.testMsg("[#s0011] Player is not null", true);
        Player player = Bukkit.getServer().getPlayer(playerUUID);
        SsomarDev.testMsg("[#s0012] Safely obtained player instance : " + player, true);
        if (!(player != null && player.isOp() || !verifSafeBreak || SafeBreak.verifSafeBreak(playerUUID, block))) {
            SsomarDev.testMsg("DEBUG SAFE BREAK VERIFICATION BLOCKED ", true);
            return false;
        }
        SsomarDev.testMsg("DEBUG SAFE BREAK 2", true);
        if (player != null) {
            SsomarDev.testMsg("DEBUG SAFE BREAK 3", true);
            boolean canceled = false;
            if (SCore.hasItemsAdder && ItemsAdderAPI.breakCustomBlock(block, player.getInventory().getItemInMainHand(), drop)) {
                return true;
            }
            if (generateBreakEvent) {
                SsomarDev.testMsg("DEBUG SAFE BREAK 4", true);
                BlockBreakEventExtension bbE = new BlockBreakEventExtension(block, player, true, breakCause);
                bbE.setCancelled(false);
                Bukkit.getPluginManager().callEvent((Event)bbE);
                canceled = bbE.isCancelled();
                if (!SCore.is1v11Less()) {
                    boolean bl = drop = bbE.isDropItems() && drop;
                }
            }
            if (!canceled) {
                if (SafeBreak.breakEB(player, block, drop)) {
                    return true;
                }
                SafeBreak.breakRoseloot(player, block, drop);
                if (SCore.is1v11Less()) {
                    SafeBreak.breakBlockNaturallyWith(block, Optional.ofNullable(player.getInventory().getItemInHand()), drop);
                } else if (slot != 40) {
                    SafeBreak.breakBlockNaturallyWith(block, Optional.ofNullable(player.getInventory().getItemInMainHand()), drop);
                } else {
                    SafeBreak.breakBlockNaturallyWith(block, Optional.ofNullable(player.getInventory().getItemInOffHand()), drop);
                }
            }
        } else {
            if (SCore.hasItemsAdder && ItemsAdderAPI.breakCustomBlock(block, null, drop)) {
                return true;
            }
            if (SafeBreak.breakEB(null, block, drop)) {
                return true;
            }
            SafeBreak.breakRoseloot(null, block, drop);
            SafeBreak.breakBlockNaturallyWith(block, Optional.empty(), drop);
        }
        return true;
    }

    public static void breakBlockNaturallyWith(final Block block, Optional<ItemStack> itemStack, boolean drop) {
        if (!SCore.is1v13Less() && block.getBlockData() instanceof Door) {
            SsomarDev.testMsg("DEBUG SAFE BREAK 8 BISECTED", true);
            Bisected b = (Bisected)block.getBlockData();
            if (b.getHalf().equals((Object)Bisected.Half.BOTTOM)) {
                if (itemStack.isPresent() && drop) {
                    block.breakNaturally(itemStack.get());
                } else if (drop) {
                    block.breakNaturally();
                }
                Runnable runnable3 = new Runnable(){

                    @Override
                    public void run() {
                        block.setType(Material.AIR);
                        block.getRelative(BlockFace.UP).setType(Material.AIR);
                    }
                };
                SCore.schedulerHook.runTask(runnable3, 1L);
            } else {
                if (itemStack.isPresent() && drop) {
                    block.breakNaturally(itemStack.get());
                } else if (drop) {
                    block.breakNaturally();
                }
                Runnable runnable3 = new Runnable(){

                    @Override
                    public void run() {
                        block.getRelative(BlockFace.DOWN).setType(Material.AIR);
                        block.setType(Material.AIR);
                    }
                };
                SCore.schedulerHook.runTask(runnable3, 1L);
            }
        } else if (block.getType().toString().toUpperCase().contains("DOOR") && !block.getType().toString().toUpperCase().contains("TRAPDOOR")) {
            if (block.getRelative(BlockFace.UP).getType().toString().toUpperCase().contains("DOOR")) {
                if (itemStack.isPresent() && drop) {
                    block.breakNaturally(itemStack.get());
                } else if (drop) {
                    block.breakNaturally();
                }
                Runnable runnable3 = new Runnable(){

                    @Override
                    public void run() {
                        block.getRelative(BlockFace.UP).setType(Material.AIR);
                        block.setType(Material.AIR);
                    }
                };
                SCore.schedulerHook.runTask(runnable3, 1L);
            } else {
                if (itemStack.isPresent() && drop) {
                    block.breakNaturally(itemStack.get());
                } else if (drop) {
                    block.breakNaturally();
                }
                Runnable runnable3 = new Runnable(){

                    @Override
                    public void run() {
                        block.getRelative(BlockFace.DOWN).setType(Material.AIR);
                        block.setType(Material.AIR);
                    }
                };
                SCore.schedulerHook.runTask(runnable3, 1L);
            }
        } else if (itemStack.isPresent() && drop) {
            block.breakNaturally(itemStack.get());
        } else if (drop) {
            block.breakNaturally();
        } else {
            block.setType(Material.AIR);
        }
    }

    public static boolean breakRoseloot(@Nullable Player player, Block block, boolean drop) {
        if (drop && SCore.hasRoseLoot) {
            try {
                LootContext context = LootContext.builder().put(LootContextParams.LOOTER, (Object)player).put(LootContextParams.LOOTED_BLOCK, (Object)block).put(LootContextParams.ORIGIN, (Object)block.getLocation()).build();
                LootResult lootResult = ((LootTableManager)RoseLoot.getInstance().getManager(LootTableManager.class)).getLoot(LootTableTypes.BLOCK, context);
                List itemsDropped = lootResult.getLootContents().getItems();
                SsomarDev.testMsg("DEBUG SAFE BREAK >> " + itemsDropped.size(), true);
                for (ItemStack itemStack : itemsDropped) {
                    block.getWorld().dropItemNaturally(block.getLocation(), itemStack);
                }
                return true;
            }
            catch (Exception e) {
                SCore.plugin.getLogger().severe("RoseLoot hook is not working properly");
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean breakEB(@Nullable Player player, Block block, boolean drop) {
        Optional eBPOpt;
        if (SCore.hasExecutableBlocks && (eBPOpt = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block)).isPresent()) {
            ExecutableBlockPlaced eBP = (ExecutableBlockPlaced)eBPOpt.get();
            eBP.breakBlock(player, drop, null, ExecutableBlockPlaced.BreakMethod.CUSTOM);
            return true;
        }
        return false;
    }

    public static boolean verifSafeBreak(@NotNull UUID playerUUID, @NotNull Block block) {
        return SafeBreak.verifSafeBreak(playerUUID, block.getLocation());
    }

    public static boolean verifSafeBreak(@NotNull UUID playerUUID, @NotNull Location location) {
        Player player = Bukkit.getServer().getPlayer(playerUUID);
        if (player != null && (player.isOp() || player.hasPermission("*"))) {
            return true;
        }
        if (SCore.hasGriefPrevention && !GriefPreventionAPI.playerCanBreakClaimBlock(playerUUID, location)) {
            SsomarDev.testMsg("DEBUG SAFE BREAK BLOCKED BY GRIEF PREVENTION", true);
            return false;
        }
        if (SCore.hasIridiumSkyblock && !IridiumSkyblockTool.playerCanBreakIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasSuperiorSkyblock2 && !SuperiorSkyblockTool.playerCanBreakIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasBentoBox && !BentoBoxAPI.playerCanBreakIslandBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasLands && !new LandsIntegrationAPI((Plugin)SCore.plugin).playerCanBreakClaimBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasFactionsUUID && !new FactionsUUIDAPI().playerCanBreakClaimBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasWorldGuard && !WorldGuardAPI.playerCanBreakInRegion(playerUUID, location)) {
            return false;
        }
        if (SCore.hasResidence && !ResidenceAPI.playerCanBreakClaimBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasTowny && !TownyToolAPI.playerCanBreakBlock(playerUUID, location)) {
            return false;
        }
        if (SCore.hasProtectionStones && !ProtectionStonesAPI.playerCanBreakClaimBlock(playerUUID, location)) {
            return false;
        }
        return !SCore.hasExcellentClaims || ExcellentClaimsAPI.playerCanBreakClaimBlock(playerUUID, location);
    }
}

