/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.sevents.registration;

import com.ssomar.sevents.EventName;
import com.ssomar.sevents.SEventFactory;
import com.ssomar.sevents.registration.Registration;
import com.ssomar.sevents.version.Version;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.event.Listener;
import org.bukkit.plugin.java.JavaPlugin;

public class DynamicRegistration {
    private static DynamicRegistration instance;
    private Map<EventName, Registration> registered = new HashMap<EventName, Registration>();

    public DynamicRegistration() {
        Version.initVersion();
    }

    public void register(EventName eventName, JavaPlugin plugin) {
        if (!this.registered.containsKey((Object)eventName)) {
            SEventFactory factory = new SEventFactory();
            List<Listener> listener = factory.getSEvent(eventName).getChildListener();
            Registration registration = new Registration(plugin, listener);
            this.registered.put(eventName, registration);
            registration.register();
        } else {
            Registration registration = this.registered.get((Object)eventName);
            if (!registration.contains(plugin)) {
                registration.addPlugin(plugin);
            }
        }
    }

    public void unregister(EventName eventName, JavaPlugin plugin) {
        Registration registration;
        if (this.registered.containsKey((Object)eventName) && (registration = this.registered.get((Object)eventName)).isHost(plugin) && !registration.transferHost()) {
            registration.unregister();
            this.registered.remove((Object)eventName);
        }
    }

    public static DynamicRegistration getInstance() {
        if (instance == null) {
            instance = new DynamicRegistration();
        }
        return instance;
    }
}

