/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands.openchest;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Chunk;
import org.bukkit.plugin.Plugin;

public class OpenChestManager {
    private static OpenChestManager instance;
    private Map<Chunk, List<UUID>> forcedChunks = new HashMap<Chunk, List<UUID>>();

    private OpenChestManager() {
    }

    public Map<Chunk, List<UUID>> getForcedChunks() {
        return this.forcedChunks;
    }

    public boolean isChunkForced(Chunk chunk) {
        return this.forcedChunks.containsKey(chunk);
    }

    public void addForcedChunk(final Chunk chunk, UUID uuid) {
        if (this.forcedChunks.containsKey(chunk)) {
            List<UUID> list = this.forcedChunks.get(chunk);
            if (!list.contains(uuid)) {
                list.add(uuid);
            }
        } else {
            ArrayList<UUID> list = new ArrayList<UUID>();
            list.add(uuid);
            this.forcedChunks.put(chunk, list);
            chunk.load();
            chunk.addPluginChunkTicket((Plugin)SCore.plugin);
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    SsomarDev.testMsg("CHUNK >>" + chunk.getX() + " " + chunk.getZ() + " >> " + chunk.getLoadLevel(), true);
                }
            };
            SCore.schedulerHook.runRepeatingTask(run, 0L, 20L);
        }
    }

    public void removeForcedChunk(Chunk chunk, UUID uuid) {
        if (this.forcedChunks.containsKey(chunk)) {
            List<UUID> list = this.forcedChunks.get(chunk);
            list.remove(uuid);
            if (list.isEmpty()) {
                this.forcedChunks.remove(chunk);
                chunk.removePluginChunkTicket((Plugin)SCore.plugin);
            }
        }
    }

    public void removeForcedChunk(UUID uuid) {
        ArrayList<Chunk> toRemove = new ArrayList<Chunk>();
        for (Chunk chunk : this.forcedChunks.keySet()) {
            List<UUID> list = this.forcedChunks.get(chunk);
            list.remove(uuid);
            if (!list.isEmpty()) continue;
            toRemove.add(chunk);
            chunk.removePluginChunkTicket((Plugin)SCore.plugin);
        }
        for (Chunk chunk : toRemove) {
            this.forcedChunks.remove(chunk);
        }
    }

    public static OpenChestManager getInstance() {
        if (instance == null) {
            instance = new OpenChestManager();
        }
        return instance;
    }
}

