/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.data.Database;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.cooldowns.Cooldown;
import com.ssomar.score.utils.logging.Utils;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CooldownsQuery {
    private static final String TABLE_COOLDOWNS = "cooldowns";
    private static final String TABLE_COOLDOWNS_NAME = "Cooldowns";
    private static final String COL_ID = "id";
    private static final String COL_UUID = "UUID";
    private static final String COL_COOLDOWN = "cooldown";
    private static final String COL_IS_IN_TICK = "isInTick";
    private static final String COL_IS_GLOBAL = "isGlobal";
    private static final String COL_TIME = "time";
    private static final String COL_PAUSED = "paused";
    private static final String COL_PAUSE_OFFLINE = "pauseOffline";
    private static final String COL_PAUSE_PLACEHOLDERS_CONDITIONS = "pausePlaceholdersConditions";
    public static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS cooldowns (id TEXT NOT NULL, UUID TEXT NOT NULL, cooldown INTEGER NOT NULL, isInTick BOOLEAN NOT NULL, isGlobal BOOLEAN NOT NULL, time LONG NOT NULL, paused BOOLEAN NOT NULL,pauseOffline BOOLEAN NOT NULL,pausePlaceholdersConditions TEXT NOT NULL);";
    public static final String RENAME_TABLE_IF_EXIST = "ALTER TABLE cooldows RENAME TO cooldowns;";
    public static final String CHECK_BEFORE_UPDATE_4_24_1_4 = "SELECT `COLUMN_NAME` FROM `INFORMATION_SCHEMA`.`COLUMNS`WHERE `TABLE_SCHEMA`= DATABASE()AND `TABLE_NAME`='cooldowns'AND `COLUMN_NAME`='pauseOffline';";
    public static final String CHECK_BEFORE_UPDATE_4_24_1_4_SQLITE = "SELECT name FROM pragma_table_info('cooldowns')WHERE name='pauseOffline';";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createNewTable(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery createNewTable");
        }
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6Cooldowns&7 if not exists...");
            String checkBeforeUpdate = CHECK_BEFORE_UPDATE_4_24_1_4_SQLITE;
            if (Database.useMySQL) {
                checkBeforeUpdate = CHECK_BEFORE_UPDATE_4_24_1_4;
            }
            try {
                stmt.execute(RENAME_TABLE_IF_EXIST);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            stmt.execute(CREATE_TABLE);
            PreparedStatement pstmt = conn.prepareStatement(checkBeforeUpdate);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                Utils.sendConsoleMsg("&eSCore &7Table &6Cooldowns &7exists, but it's not up to date, updating...");
                stmt.execute("ALTER TABLE cooldowns DROP COLUMN loaded;");
                stmt.execute("ALTER TABLE cooldowns ADD COLUMN paused BOOLEAN NOT NULL DEFAULT FALSE;");
                stmt.execute("ALTER TABLE cooldowns ADD COLUMN pauseOffline BOOLEAN NOT NULL DEFAULT FALSE;");
                stmt.execute("ALTER TABLE cooldowns ADD COLUMN pausePlaceholdersConditions TEXT NOT NULL DEFAULT '';");
            }
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("Error while creating table Cooldowns in database " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertCooldowns(Connection conn, List<Cooldown> cooldowns) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery insertCooldowns");
        }
        String sql = "INSERT INTO cooldowns (id,UUID,cooldown,isInTick,isGlobal,time,paused,pauseOffline,pausePlaceholdersConditions) VALUES(?,?,?,?,?,?,?,?,?)";
        PreparedStatement pstmt = null;
        int i = 0;
        try {
            pstmt = conn.prepareStatement(sql);
            for (Cooldown cd : cooldowns) {
                ++i;
                if (cd != null) {
                    pstmt.setString(1, cd.getId());
                    pstmt.setString(2, cd.getEntityUUID() + "");
                    pstmt.setInt(3, cd.getCooldown());
                    pstmt.setBoolean(4, cd.isInTick());
                    pstmt.setBoolean(5, cd.isGlobal());
                    pstmt.setLong(6, cd.getTime());
                    pstmt.setBoolean(7, cd.isPaused());
                    pstmt.setBoolean(8, cd.isPauseWhenOffline());
                    pstmt.setString(9, cd.getPausePlaceholdersConditions().getConfigAsString());
                    pstmt.addBatch();
                }
                if (i % 1000 != 0 && i != cooldowns.size()) continue;
                pstmt.executeBatch();
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Cooldown> getCooldownsOf(Connection conn, UUID uuid) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery getCooldownsOf");
        }
        String sql = "SELECT id,UUID,cooldown,isInTick,isGlobal,time,paused,pauseOffline,pausePlaceholdersConditions FROM cooldowns where UUID=?";
        ArrayList<Cooldown> list = new ArrayList<Cooldown>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, uuid.toString());
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString(COL_ID);
                String uuidStr = rs.getString(COL_UUID);
                int cd = rs.getInt(COL_COOLDOWN);
                boolean isInTick = rs.getBoolean(COL_IS_IN_TICK);
                boolean isGlobal = rs.getBoolean(COL_IS_GLOBAL);
                long time = rs.getLong(COL_TIME);
                boolean paused = rs.getBoolean(COL_PAUSED);
                boolean pauseOffline = rs.getBoolean(COL_PAUSE_OFFLINE);
                String pausePlaceholdersConditions = rs.getString(COL_PAUSE_PLACEHOLDERS_CONDITIONS);
                PlaceholderConditionGroupFeature placeholderConditionGroupFeature = new PlaceholderConditionGroupFeature(null);
                StringReader reader = new StringReader(pausePlaceholdersConditions);
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((Reader)reader);
                placeholderConditionGroupFeature.load(SCore.plugin, (ConfigurationSection)yamlConfiguration, true);
                Cooldown cooldown = new Cooldown(id, UUID.fromString(uuidStr), cd, isInTick, time, isGlobal);
                cooldown.setPauseFeatures(pauseOffline, placeholderConditionGroupFeature);
                cooldown.setPaused(paused);
                list.add(cooldown);
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Cooldown> getGlobalCooldowns(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery getGlobalCooldowns");
        }
        String sql = "SELECT id,UUID,cooldown,isInTick,isGlobal,time FROM cooldowns where isGlobal=true";
        ArrayList<Cooldown> list = new ArrayList<Cooldown>();
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = conn.prepareStatement(sql);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String id = rs.getString(COL_ID);
                int cd = rs.getInt(COL_COOLDOWN);
                boolean isInTick = rs.getBoolean(COL_IS_IN_TICK);
                boolean isGlobal = rs.getBoolean(COL_IS_GLOBAL);
                long time = rs.getLong(COL_TIME);
                Cooldown cooldown = new Cooldown(id, null, cd, isInTick, time, isGlobal);
                list.add(cooldown);
            }
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteCooldownsOf(Connection conn, UUID uuid) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery deleteCooldownsOf");
        }
        String sql = "DELETE FROM cooldowns where UUID=?";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.setString(1, uuid.toString());
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteGlobalCooldowns(Connection conn) {
        if (Database.DEBUG) {
            Utils.sendConsoleMsg("CooldownsQuery deleteGlobalCooldowns");
        }
        String sql = "DELETE FROM cooldowns where isGlobal=true";
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement(sql);
            pstmt.executeUpdate();
        }
        catch (SQLException e) {
            System.out.println("&e[SCore] " + e.getMessage());
        }
        finally {
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

