/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures.DamageReductionFeature;
import com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures.group.DamageReductionGroupFeatureEditor;
import com.ssomar.score.features.custom.blocksAttacksFeatures.DamageReductionFeatures.group.DamageReductionGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.item.blocksattacks.DamageReduction;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DamageReductionGroupFeature
extends FeatureWithHisOwnEditor<DamageReductionGroupFeature, DamageReductionGroupFeature, DamageReductionGroupFeatureEditor, DamageReductionGroupFeatureEditorManager>
implements FeaturesGroup<DamageReductionFeature> {
    private Map<String, DamageReductionFeature> reductions;
    private boolean notSaveIfNoValue;

    public DamageReductionGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.damageReductions);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.reductions = new HashMap<String, DamageReductionFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String enchantmentID : enchantmentsSection.getKeys(false)) {
                ConfigurationSection enchantmentSection;
                DamageReductionFeature enchantment = new DamageReductionFeature((FeatureParentInterface)this, enchantmentID);
                List<String> subErrors = enchantment.load(plugin, enchantmentSection = enchantmentsSection.getConfigurationSection(enchantmentID), isPremiumLoading);
                if (!subErrors.isEmpty()) {
                    error.addAll(subErrors);
                    continue;
                }
                this.reductions.put(enchantmentID, enchantment);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.reductions.isEmpty()) {
            return;
        }
        ConfigurationSection enchantmentsSection = config.createSection(this.getName());
        for (String enchantmentID : this.reductions.keySet()) {
            this.reductions.get(enchantmentID).save(enchantmentsSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && enchantmentsSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public DamageReductionGroupFeature getValue() {
        return this;
    }

    public void setValues(List<DamageReduction> reductions) {
        this.reductions.clear();
        int i = 0;
        for (DamageReduction reduction : reductions) {
            DamageReductionFeature reductionFeature = new DamageReductionFeature((FeatureParentInterface)this, i + "");
            reductionFeature.fromDamageReduction(reduction);
            this.reductions.put(i + "", reductionFeature);
            ++i;
        }
    }

    @Override
    public DamageReductionGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oDamageReduction(s) added: &e" + this.reductions.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public DamageReductionFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (DamageReductionFeature x : this.reductions.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public DamageReductionGroupFeature clone(FeatureParentInterface newParent) {
        DamageReductionGroupFeature eF = new DamageReductionGroupFeature(newParent, this.isNotSaveIfNoValue());
        HashMap<String, DamageReductionFeature> newEnchantments = new HashMap<String, DamageReductionFeature>();
        for (String x : this.reductions.keySet()) {
            newEnchantments.put(x, this.reductions.get(x).clone(eF));
        }
        eF.setReductions(newEnchantments);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.reductions.values());
    }

    @Override
    public String getParentInfo() {
        if (this.getParent() == this) {
            return "";
        }
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DamageReductionGroupFeature)) continue;
            DamageReductionGroupFeature eF = (DamageReductionGroupFeature)feature;
            eF.setReductions(this.getReductions());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        DamageReductionGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "damageReduction";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.reductions.containsKey(id)) continue;
            DamageReductionFeature eF = new DamageReductionFeature((FeatureParentInterface)this, id);
            this.reductions.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, DamageReductionFeature feature) {
        this.reductions.remove(feature.getId());
    }

    public List<DamageReduction> asList() {
        ArrayList<DamageReduction> list = new ArrayList<DamageReduction>();
        for (DamageReductionFeature reduction : this.reductions.values()) {
            list.add(reduction.asDamageReduction());
        }
        return list;
    }

    @Generated
    public Map<String, DamageReductionFeature> getReductions() {
        return this.reductions;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public void setReductions(Map<String, DamageReductionFeature> reductions) {
        this.reductions = reductions;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

