/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.headfeatures;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.profile.PlayerProfile;
import org.bukkit.profile.PlayerTextures;
import org.json.JSONObject;

public class HeadBuilder118 {
    private static final UUID RANDOM_UUID = UUID.fromString("b33183ad-e9c0-4d48-8eea-f8c9358d3568");

    private static PlayerProfile getProfile(String url) {
        URL urlObject;
        PlayerProfile profile = Bukkit.createPlayerProfile((UUID)RANDOM_UUID);
        PlayerTextures textures = profile.getTextures();
        try {
            urlObject = new URL(url);
        }
        catch (MalformedURLException exception) {
            throw new RuntimeException("Invalid URL", exception);
        }
        textures.setSkin(urlObject);
        profile.setTextures(textures);
        return profile;
    }

    public static ItemStack getHead(String url) {
        PlayerProfile profile = HeadBuilder118.getProfile(url);
        ItemStack head = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)head.getItemMeta();
        meta.setOwnerProfile(profile);
        head.setItemMeta((ItemMeta)meta);
        return head;
    }

    public static void modifyMeta(SkullMeta meta, String url) {
        PlayerProfile profile = HeadBuilder118.getProfile(url);
        meta.setOwnerProfile(profile);
    }

    public static URL getUrlFromBase64(String base64) throws MalformedURLException {
        String decoded = new String(Base64.getDecoder().decode(base64));
        JSONObject obj = new JSONObject(decoded);
        String url = obj.getJSONObject("textures").getJSONObject("SKIN").getString("url");
        return new URL(url);
    }

    public static String getBase64FromUrl(String url) {
        PlayerProfile profile = HeadBuilder118.getProfile(url);
        JSONObject textures = new JSONObject();
        JSONObject skin = new JSONObject();
        skin.put("url", profile.getTextures().getSkin().toString());
        textures.put("SKIN", skin);
        JSONObject profile2 = new JSONObject();
        profile2.put("textures", textures);
        return Base64.getEncoder().encodeToString(profile2.toString().getBytes());
    }
}

