/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.variables.base.variable;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloaded;
import com.ssomar.score.features.editor.GenericFeatureParentEditorReloadedManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.features.types.DoubleFeature;
import com.ssomar.score.features.types.UncoloredStringFeature;
import com.ssomar.score.features.types.VariableTypeFeature;
import com.ssomar.score.features.types.list.ListColoredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.emums.VariableType;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VariableFeature<T>
extends FeatureWithHisOwnEditor<VariableFeature, VariableFeature<T>, GenericFeatureParentEditorReloaded, GenericFeatureParentEditorReloadedManager> {
    private static final boolean DEBUG = true;
    private UncoloredStringFeature variableName;
    private VariableTypeFeature type;
    private ColoredStringFeature stringValue;
    private DoubleFeature doubleValue;
    private ListColoredStringFeature listValue;
    private String id;
    private BooleanFeature isRefreshableClean;
    private ColoredStringFeature refreshTag;

    public VariableFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.variable);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.variableName = new UncoloredStringFeature(this, Optional.of("var"), FeatureSettingsSCore.variableName, false);
        this.type = new VariableTypeFeature(this, Optional.of(VariableType.STRING), FeatureSettingsSCore.type, false);
        this.stringValue = new ColoredStringFeature(this, Optional.of(""), FeatureSettingsSCore.default_string);
        this.doubleValue = new DoubleFeature(this, Optional.of(0.0), FeatureSettingsSCore.default_double);
        this.listValue = new ListColoredStringFeature((FeatureParentInterface)this, new ArrayList<String>(), FeatureSettingsSCore.default_list, Optional.empty());
        this.isRefreshableClean = new BooleanFeature(this, false, FeatureSettingsSCore.isRefreshableClean);
        this.refreshTag = new ColoredStringFeature(this, Optional.of(""), FeatureSettingsSCore.refreshTag);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.variableName.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.type.load(plugin, enchantmentConfig, isPremiumLoading));
            if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.STRING)) {
                errors.addAll(this.stringValue.load(plugin, enchantmentConfig, isPremiumLoading));
            } else if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
                errors.addAll(this.listValue.load(plugin, enchantmentConfig, isPremiumLoading));
            } else {
                errors.addAll(this.doubleValue.load(plugin, enchantmentConfig, isPremiumLoading));
            }
            errors.addAll(this.isRefreshableClean.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.refreshTag.load(plugin, enchantmentConfig, isPremiumLoading));
            if (this.isRefreshableClean.getValue().booleanValue() && ((String)((Optional)this.refreshTag.getValue()).get()).isEmpty()) {
                this.refreshTag.setValue(this.generateTag());
            }
        } else {
            errors.add("&cERROR, Couldn't load the Variable with its options because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    public String generateTag() {
        return VariableFeature.generateTag((String)((Optional)this.variableName.getValue()).get());
    }

    public static String generateTag(String variableName) {
        int hashCode = variableName.hashCode();
        if (hashCode < 0) {
            hashCode = -hashCode;
        }
        String hashToString = Integer.toString(hashCode);
        StringBuilder tag = new StringBuilder();
        for (int i = 0; i < hashToString.length(); ++i) {
            tag.append("\u00a7").append(VariableFeature.encodeIntegers().get(Integer.parseInt(String.valueOf(hashToString.charAt(i)))));
        }
        return tag.toString();
    }

    public static Map<Integer, String> encodeIntegers() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(0, "\u81ea");
        result.put(1, "\u4ed6");
        result.put(2, "\u5730");
        result.put(3, "\u5929");
        result.put(4, "\u4eba");
        result.put(5, "\u9053");
        result.put(6, "\u751f");
        result.put(7, "\u7269");
        result.put(8, "\u5fc3");
        result.put(9, "\u610f");
        return result;
    }

    public T getDefaultValue() {
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.STRING)) {
            return ((Optional)this.stringValue.getValue()).get();
        }
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
            return (T)this.listValue.getValue();
        }
        return (T)this.doubleValue.getValue(null, new StringPlaceholder()).get();
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.variableName.save(attributeConfig);
        this.type.save(attributeConfig);
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.STRING)) {
            this.stringValue.save(attributeConfig);
        } else if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
            this.listValue.save(attributeConfig);
        } else {
            this.doubleValue.save(attributeConfig);
        }
        this.isRefreshableClean.save(attributeConfig);
        this.refreshTag.save(attributeConfig);
    }

    @Override
    public VariableFeature getValue() {
        return this;
    }

    @Override
    public VariableFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = "&7Name: &e" + (String)((Optional)this.variableName.getValue()).get();
        finalDescription[finalDescription.length - 3] = "&7Type: &e" + ((Optional)this.type.getValue()).get();
        finalDescription[finalDescription.length - 2] = ((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.STRING) ? "&7Default: &e" + (String)((Optional)this.stringValue.getValue()).get() : (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST) ? "&7Default: &e" + Arrays.toString(this.listValue.getValue().toArray()) : "&7Default: &e" + ((Optional)this.doubleValue.getValue()).get());
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public VariableFeature clone(FeatureParentInterface parent) {
        VariableFeature<T> eF = new VariableFeature<T>(parent, this.id);
        eF.setVariableName(this.variableName.clone(eF));
        eF.setType(this.type.clone(eF));
        eF.setStringValue(this.stringValue.clone(eF));
        eF.setDoubleValue(this.doubleValue.clone(eF));
        eF.setListValue(this.listValue.clone(eF));
        eF.setIsRefreshableClean(this.isRefreshableClean.clone(eF));
        eF.setRefreshTag(this.refreshTag.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> featureInterfaces = new ArrayList<FeatureInterface>(Arrays.asList(this.variableName, this.type));
        if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.STRING)) {
            featureInterfaces.add(this.stringValue);
        } else if (((VariableType)((Optional)this.type.getValue()).get()).equals(VariableType.LIST)) {
            featureInterfaces.add(this.listValue);
        } else {
            featureInterfaces.add(this.doubleValue);
        }
        featureInterfaces.add(this.isRefreshableClean);
        return featureInterfaces;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            VariableFeature aFOF;
            if (!(feature instanceof VariableFeature) || !(aFOF = (VariableFeature)feature).getId().equals(this.id)) continue;
            aFOF.setVariableName(this.variableName);
            aFOF.setType(this.type);
            aFOF.setStringValue(this.stringValue);
            aFOF.setDoubleValue(this.doubleValue);
            aFOF.setListValue(this.listValue);
            aFOF.setIsRefreshableClean(this.isRefreshableClean);
            aFOF.setRefreshTag(this.refreshTag);
            if (!this.isRefreshableClean.getValue().booleanValue() || !((String)((Optional)this.refreshTag.getValue()).get()).isEmpty()) break;
            this.refreshTag.setValue(this.generateTag());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorReloadedManager.getInstance().startEditing(player, this);
    }

    @Generated
    public UncoloredStringFeature getVariableName() {
        return this.variableName;
    }

    @Generated
    public VariableTypeFeature getType() {
        return this.type;
    }

    @Generated
    public ColoredStringFeature getStringValue() {
        return this.stringValue;
    }

    @Generated
    public DoubleFeature getDoubleValue() {
        return this.doubleValue;
    }

    @Generated
    public ListColoredStringFeature getListValue() {
        return this.listValue;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public BooleanFeature getIsRefreshableClean() {
        return this.isRefreshableClean;
    }

    @Generated
    public ColoredStringFeature getRefreshTag() {
        return this.refreshTag;
    }

    @Generated
    public void setVariableName(UncoloredStringFeature variableName) {
        this.variableName = variableName;
    }

    @Generated
    public void setType(VariableTypeFeature type) {
        this.type = type;
    }

    @Generated
    public void setStringValue(ColoredStringFeature stringValue) {
        this.stringValue = stringValue;
    }

    @Generated
    public void setDoubleValue(DoubleFeature doubleValue) {
        this.doubleValue = doubleValue;
    }

    @Generated
    public void setListValue(ListColoredStringFeature listValue) {
        this.listValue = listValue;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }

    @Generated
    public void setIsRefreshableClean(BooleanFeature isRefreshableClean) {
        this.isRefreshableClean = isRefreshableClean;
    }

    @Generated
    public void setRefreshTag(ColoredStringFeature refreshTag) {
        this.refreshTag = refreshTag;
    }
}

