/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.FireworkEffect;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class FireworkEffectTypeFeature
extends FeatureAbstract<Optional<FireworkEffect.Type>, FireworkEffectTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<FireworkEffect.Type> value;
    private Optional<FireworkEffect.Type> defaultValue;

    public FireworkEffectTypeFeature(FeatureParentInterface parent, Optional<FireworkEffect.Type> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            this.value = this.defaultValue;
        } else {
            try {
                FireworkEffect.Type attributeSlot = FireworkEffect.Type.valueOf((String)colorStr.toUpperCase());
                this.value = Optional.ofNullable(attributeSlot);
                FeatureReturnCheckPremium<FireworkEffect.Type> checkPremium = this.checkPremium("FireworkEffectType", attributeSlot, this.defaultValue, isPremiumLoading);
                if (checkPremium.isHasError()) {
                    this.value = Optional.of(checkPremium.getNewValue());
                }
            }
            catch (Exception e) {
                errors.add("&cERROR, Couldn't load the FireworkEffectType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> List: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/FireworkEffect.Type.html");
                this.value = Optional.empty();
            }
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(potionType -> config.set(this.getName(), (Object)potionType.name()));
    }

    @Override
    public Optional<FireworkEffect.Type> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public FireworkEffectTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        FireworkEffect.Type finalValue = ((Optional)value).orElse(FireworkEffect.Type.BALL);
        this.updateFireworkEffectType(finalValue, gui);
    }

    @Override
    public FireworkEffectTypeFeature clone(FeatureParentInterface newParent) {
        FireworkEffectTypeFeature clone = new FireworkEffectTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        FireworkEffect.Type slot = this.getFireworkEffectType((GUI)manager.getCache().get(editor));
        slot = this.nextFireworkEffectType(slot);
        this.updateFireworkEffectType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        FireworkEffect.Type slot = this.getFireworkEffectType((GUI)manager.getCache().get(editor));
        slot = this.prevFireworkEffectType(slot);
        this.updateFireworkEffectType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateFireworkEffectType(this.nextFireworkEffectType(this.getFireworkEffectType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateFireworkEffectType(this.prevFireworkEffectType(this.getFireworkEffectType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public FireworkEffect.Type nextFireworkEffectType(FireworkEffect.Type slot) {
        boolean next = false;
        for (FireworkEffect.Type check : this.getSortFireworkEffectTypes()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortFireworkEffectTypes().get(0);
    }

    public FireworkEffect.Type prevFireworkEffectType(FireworkEffect.Type slot) {
        int i = -1;
        int cpt = 0;
        for (FireworkEffect.Type check : this.getSortFireworkEffectTypes()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortFireworkEffectTypes().get(this.getSortFireworkEffectTypes().size() - 1);
        }
        return this.getSortFireworkEffectTypes().get(cpt - 1);
    }

    public void updateFireworkEffectType(FireworkEffect.Type slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortFireworkEffectTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (FireworkEffect.Type check : this.getSortFireworkEffectTypes()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (FireworkEffect.Type check : this.getSortFireworkEffectTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public FireworkEffect.Type getFireworkEffectType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return FireworkEffect.Type.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<FireworkEffect.Type> getSortFireworkEffectTypes() {
        TreeMap<String, FireworkEffect.Type> map = new TreeMap<String, FireworkEffect.Type>();
        for (FireworkEffect.Type l : FireworkEffect.Type.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<FireworkEffect.Type>(map.values());
    }

    @Generated
    public Optional<FireworkEffect.Type> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<FireworkEffect.Type> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<FireworkEffect.Type> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

