/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.emums.CustomColor;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Color;
import org.bukkit.entity.Player;

public class ListBukkitColorFeature
extends ListFeatureAbstract<Color, ListBukkitColorFeature> {
    private Optional<List<Suggestion>> suggestions;

    public ListBukkitColorFeature(FeatureParentInterface parent, List<Color> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, "List of Bukkit colors", defaultValue, featureSettings);
        this.suggestions = suggestions;
        this.reset();
    }

    @Override
    public List<Color> loadValues(List<String> entries, List<String> errors) {
        ArrayList<Color> val2 = new ArrayList<Color>();
        for (String s : entries) {
            Color color = CustomColor.valueOf(s);
            if (color == null) continue;
            val2.add(color);
        }
        return val2;
    }

    @Override
    public String transfromToString(Color value) {
        return CustomColor.getName(value);
    }

    @Override
    public ListBukkitColorFeature clone(FeatureParentInterface newParent) {
        ListBukkitColorFeature clone = new ListBukkitColorFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), this.suggestions);
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        if (CustomColor.valueOf(message = StringConverter.decoloredString(message).trim()) == null) {
            return Optional.of("&cThis color doesn't exist &7https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Color.html");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return new ArrayList<TextComponent>();
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return this.suggestions.orElseGet(ArrayList::new);
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    @Generated
    public void setSuggestions(Optional<List<Suggestion>> suggestions) {
        this.suggestions = suggestions;
    }
}

