/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.api.executableitems.ExecutableItemsAPI;
import com.ssomar.score.api.executableitems.config.ExecutableItemInterface;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.strings.StringSetting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DropExecutableItem
extends BlockCommand {
    public DropExecutableItem() {
        CommandSetting id = new CommandSetting("id", 0, String.class, (Object)"null");
        CommandSetting amount = new CommandSetting("amount", 1, Integer.class, (Object)1);
        CommandSetting owner = new CommandSetting("owner", 2, String.class, null);
        CommandSetting itemdata = new CommandSetting("itemdata", 3, String.class, (Object)"null");
        List<CommandSetting> settings = this.getSettings();
        settings.add(id);
        settings.add(amount);
        settings.add(owner);
        settings.add(itemdata);
        this.setNewSettingsMode(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        Optional<ExecutableItemInterface> eiOpt;
        String id = (String)sCommandToExec.getSettingValue("id");
        int amount = (Integer)sCommandToExec.getSettingValue("amount");
        String owner = (String)sCommandToExec.getSettingValue("owner");
        String itemData = (String)sCommandToExec.getSettingValue("itemdata");
        HashMap<String, Object> settings = new HashMap();
        if (!itemData.equals("null")) {
            settings = StringSetting.getSettings(itemData);
        }
        if (!SCore.hasExecutableItems || !ExecutableItemsAPI.getExecutableItemsManager().isValidID(id)) {
            SCore.plugin.getLogger().info(ChatColor.RED + "Invalid ID was provided for a DROPEXECUTABLEITEM command. Please double check your DROPEXECUTABLEITEM commands.");
            return;
        }
        Optional<Object> playerOwner = Optional.empty();
        if (owner != null) {
            try {
                playerOwner = Optional.ofNullable(Bukkit.getPlayer((UUID)UUID.fromString(owner)));
            }
            catch (Exception exception) {
            }
            finally {
                if (!playerOwner.isPresent()) {
                    playerOwner = Optional.ofNullable(Bukkit.getPlayer((String)owner));
                }
            }
        }
        if (!playerOwner.isPresent() || playerOwner.get() == null) {
            playerOwner = Optional.ofNullable(p);
        }
        if (SCore.hasExecutableItems && ExecutableItemsAPI.getExecutableItemsManager().isValidID(id) && amount > 0 && amount > 0 && (eiOpt = ExecutableItemsAPI.getExecutableItemsManager().getExecutableItem(id)).isPresent()) {
            ExecutableItemInterface ei = eiOpt.get();
            block.getWorld().dropItem(block.getLocation(), ei.buildItem(amount, playerOwner, settings));
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DROPEXECUTABLEITEM");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DROPEXECUTABLEITEM id:{id} amount:{number} owner:{ign/uuid} itemdata:{usage/variables/durability w/o no outer side brackets}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

