/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.block.commands;

import com.bgsoftware.wildstacker.api.WildStackerAPI;
import com.bgsoftware.wildstacker.api.objects.StackedSpawner;
import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.block.BlockCommand;
import com.ssomar.score.utils.strings.StringConverter;
import dev.rosewood.rosestacker.api.RoseStackerAPI;
import dev.rosewood.rosestacker.nms.spawner.SpawnerType;
import dev.rosewood.rosestacker.utils.ItemUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SilkSpawner
extends BlockCommand {
    @Override
    public void run(@Nullable Player p, @NotNull Block block, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        if (SCore.hasRoseStacker && args.size() == 1 && args.get(0).equalsIgnoreCase("RoseStacker")) {
            dev.rosewood.rosestacker.stack.StackedSpawner sp = RoseStackerAPI.getInstance().getStackedSpawner(block);
            if (sp == null) {
                return;
            }
            ItemStack item = ItemUtils.getSpawnerAsStackedItemStack((SpawnerType)sp.getSpawnerTile().getSpawnerType(), (int)sp.getStackSize());
            sp.setStackSize(0);
            RoseStackerAPI.getInstance().removeSpawnerStack(sp);
            block.setType(Material.AIR);
            if (p != null) {
                p.getInventory().addItem(new ItemStack[]{item});
            }
        } else if (SCore.hasWildStacker && args.size() == 1 && args.get(0).equalsIgnoreCase("WildStacker")) {
            Material spawer = SCore.is1v12Less() ? Material.valueOf((String)"MOB_SPAWNER") : Material.SPAWNER;
            if (block.getType().equals((Object)spawer)) {
                CreatureSpawner cs = (CreatureSpawner)block.getState();
                StackedSpawner sp = WildStackerAPI.getStackedSpawner((CreatureSpawner)cs);
                if (sp == null) {
                    return;
                }
                ItemStack item = sp.getDropItem(sp.getStackAmount());
                sp.remove();
                block.setType(Material.AIR);
                if (p != null) {
                    p.getInventory().addItem(new ItemStack[]{item});
                }
            }
        } else {
            Material spawer = SCore.is1v12Less() ? Material.valueOf((String)"MOB_SPAWNER") : Material.SPAWNER;
            if (block.getType().equals((Object)spawer)) {
                CreatureSpawner cs = (CreatureSpawner)block.getState();
                ItemStack spawner_to_give = new ItemStack(spawer);
                BlockStateMeta meta = (BlockStateMeta)spawner_to_give.getItemMeta();
                CreatureSpawner csm = (CreatureSpawner)meta.getBlockState();
                csm.setSpawnedType(cs.getSpawnedType());
                if (csm.getSpawnedType() != null) {
                    String name = csm.getSpawnedType().toString().replace("_", " ");
                    name = name.toLowerCase();
                    name = (name.charAt(0) + "").toUpperCase() + name.substring(1, name.length());
                    name = "&e" + name;
                    name = StringConverter.coloredString(name);
                    meta.setDisplayName(name);
                    if (!SCore.is1v20v5Plus()) {
                        meta.setLocalizedName("FROM_EXECUTABLEITEM");
                    } else {
                        PersistentDataContainer container = meta.getPersistentDataContainer();
                        NamespacedKey key = new NamespacedKey((Plugin)SCore.plugin, "SPAWNER_SILK_SCORE");
                        container.set(key, PersistentDataType.STRING, (Object)"OK");
                    }
                }
                meta.setBlockState((BlockState)csm);
                meta.addItemFlags(new ItemFlag[0]);
                spawner_to_give.setItemMeta((ItemMeta)meta);
                block.setType(Material.AIR);
                if (p == null || this.getAvailableSlots(p) <= 0) {
                    block.getWorld().dropItemNaturally(block.getLocation(), spawner_to_give);
                } else {
                    p.getInventory().addItem(new ItemStack[]{spawner_to_give});
                }
            }
        }
    }

    private int getAvailableSlots(Player player) {
        int availableSlots = 0;
        for (int i = 0; i < 36; ++i) {
            ItemStack item = player.getInventory().getItem(i);
            if (item != null && item.getType() != Material.AIR) continue;
            ++availableSlots;
        }
        return availableSlots;
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SILK_SPAWNER");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SILK_SPAWNER [RoseStacker or WildStacker or ]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

