/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.utils.numbers.NTools;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import net.objecthunter.exp4j.Expression;
import net.objecthunter.exp4j.ExpressionBuilder;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class CustomDash3
extends MixedCommand {
    @Override
    public void run(Player p, final Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        final String function = args.get(0);
        double maxX = NTools.getInteger(args.get(1)).get().intValue();
        if (maxX <= 0.0) {
            return;
        }
        int front = 1;
        if (args.get(2).equalsIgnoreCase("false")) {
            front = -1;
        }
        final int steps = (int)(maxX * 10.0);
        final int[] currentStep = new int[]{0};
        final double stepSize = maxX / (double)steps;
        final Integer finalFront = front;
        final AtomicReference<Object> task = new AtomicReference<Object>(null);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (currentStep[0] >= steps) {
                    ((ScheduledTask)task.get()).cancel();
                    return;
                }
                Expression expression = new ExpressionBuilder(function).variables("x").build();
                double x = (double)currentStep[0] * stepSize;
                double y = expression.setVariable("x", x).evaluate();
                double nextX = (double)(currentStep[0] + 1) * stepSize;
                double nextY = expression.setVariable("x", nextX).evaluate();
                double yVelocity = (nextY - y) * 2.0;
                double yaw = receiver.getLocation().getYaw();
                if (yaw < 0.0) {
                    yaw += 360.0;
                }
                yaw = Math.toRadians(yaw);
                Vector velocity = new Vector((double)finalFront.intValue() * (-stepSize * Math.sin(yaw)), yVelocity, (double)finalFront.intValue() * (stepSize * Math.cos(yaw)));
                receiver.setVelocity(velocity);
                currentStep[0] = currentStep[0] + 1;
            }
        };
        task.set(SCore.schedulerHook.runRepeatingTask(runnable, 1L, 1L));
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        if (args.size() < 3) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + this.getTemplate());
        }
        ArgumentChecker ac1 = CustomDash3.checkInteger(args.get(1), isFinalVerification, this.getTemplate());
        if (!ac1.isValid()) {
            return Optional.of(ac1.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("CUSTOMDASH3");
        return names;
    }

    @Override
    public String getTemplate() {
        return "CUSTOMDASH3 {function} {max x value} {front z default TRUE}";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

