/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.commands.runnable.ActionInfo;
import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.Damage;
import com.ssomar.score.events.DamageWithoutKnockbackListener;
import com.ssomar.score.usedapi.WorldGuardAPI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class DamageNoKnockback
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        ActionInfo aInfo = sCommandToExec.getActionInfo();
        if (!(receiver instanceof LivingEntity)) {
            return;
        }
        LivingEntity livingReceiver = (LivingEntity)receiver;
        if (receiver == null) {
            return;
        }
        double damage = Damage.getDamage(p, livingReceiver, args, aInfo);
        if (damage > 0.0 && !receiver.isDead()) {
            int maximumNoDmg = livingReceiver.getNoDamageTicks();
            livingReceiver.setNoDamageTicks(0);
            boolean doDamage = true;
            if (SCore.hasWorldGuard && receiver instanceof Player) {
                doDamage = WorldGuardAPI.isInPvpZone((Player)receiver, receiver.getLocation());
            }
            if (doDamage) {
                if (p != null) {
                    if (aInfo.isActionRelatedToDamageEvent()) {
                        p.setMetadata("cancelDamageEvent", (MetadataValue)new FixedMetadataValue((Plugin)SCore.plugin, (Object)7772));
                    }
                    p.setMetadata("damageFromCustomCommand", (MetadataValue)new FixedMetadataValue((Plugin)SCore.plugin, (Object)7773));
                    DamageWithoutKnockbackListener.getInstance().addDamageWithoutKnockback(receiver);
                    SsomarDev.testMsg(DamageWithoutKnockbackListener.getInstance().getDamageWithoutKnockbackList().size() + "<<<<<<<<<", true);
                    livingReceiver.damage(damage, (Entity)p);
                } else {
                    DamageWithoutKnockbackListener.getInstance().addDamageWithoutKnockback(receiver);
                    livingReceiver.damage(damage);
                }
            }
            livingReceiver.setNoDamageTicks(maximumNoDmg);
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return DamageNoKnockback.staticVerif(args, isFinalVerification, this.getTemplate());
    }

    public static Optional<String> staticVerif(List<String> args, boolean isFinalVerification, String template) {
        String value;
        ArgumentChecker ac2;
        if (args.size() < 1) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + template);
        }
        ArgumentChecker ac = DamageNoKnockback.checkDouble(args.get(0), isFinalVerification, template, true);
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        if (args.size() >= 2 && !(ac2 = DamageNoKnockback.checkBoolean(value = args.get(1), isFinalVerification, template)).isValid()) {
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 3 && !(ac2 = DamageNoKnockback.checkBoolean(value = args.get(2), isFinalVerification, template)).isValid()) {
            return Optional.of(ac2.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("DAMAGE_NO_KNOCKBACK");
        return names;
    }

    @Override
    public String getTemplate() {
        return "DAMAGE_NO_KNOCKBACK {number} [amplified If Strength Effect, true or false] [amplified with attack attribute, true or false]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

