/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkEffectMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class SetItemColor
extends PlayerCommand {
    public SetItemColor() {
        CommandSetting slot = new CommandSetting("slot", 0, Integer.class, (Object)-1);
        slot.setSlot(true);
        CommandSetting color = new CommandSetting("color", 1, Integer.class, (Object)0xCCFEFF);
        List<CommandSetting> settings = this.getSettings();
        settings.add(slot);
        settings.add(color);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        int color = (Integer)sCommandToExec.getSettingValue("color");
        int slot = (Integer)sCommandToExec.getSettingValue("slot");
        ItemStack item = slot == -1 ? receiver.getInventory().getItemInMainHand() : receiver.getInventory().getItem(slot);
        if (item == null || item.getType() == Material.AIR) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        ItemMeta itemmeta = item.getItemMeta();
        Material material = item.getType();
        if (material.equals((Object)Material.LEATHER_BOOTS) || material.equals((Object)Material.LEATHER_CHESTPLATE) || material.equals((Object)Material.LEATHER_LEGGINGS) || material.equals((Object)Material.LEATHER_HELMET) || !SCore.is1v13Less() && material.equals((Object)Material.LEATHER_HORSE_ARMOR)) {
            LeatherArmorMeta aMeta = (LeatherArmorMeta)itemmeta;
            aMeta.setColor(Color.fromRGB((int)color));
        } else if (itemmeta instanceof FireworkEffectMeta) {
            FireworkEffectMeta fMeta = (FireworkEffectMeta)itemmeta;
            FireworkEffect aa = FireworkEffect.builder().withColor(Color.fromRGB((int)color)).build();
            fMeta.setEffect(aa);
        }
        item.setItemMeta(itemmeta);
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SET_ITEM_COLOR");
        names.add("SETITEMCOLOR");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SET_ITEM_COLOR slot:-1 color:13434623";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

