/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.player.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.player.PlayerCommand;
import com.ssomar.score.utils.EntityBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class SpawnEntityOnCursor
extends PlayerCommand {
    public SpawnEntityOnCursor() {
        CommandSetting entity = new CommandSetting("entity", 0, EntityBuilder.class, (Object)"ZOMBIE");
        CommandSetting amount = new CommandSetting("amount", 1, Integer.class, (Object)1);
        CommandSetting maxRange = new CommandSetting("maxRange", 2, Integer.class, (Object)200);
        List<CommandSetting> settings = this.getSettings();
        settings.add(entity);
        settings.add(amount);
        settings.add(maxRange);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Player receiver, SCommandToExec sCommandToExec) {
        int range = (Integer)sCommandToExec.getSettingValue("maxRange");
        int amount = (Integer)sCommandToExec.getSettingValue("amount");
        EntityBuilder entityBuilder = (EntityBuilder)sCommandToExec.getSettingValue("entity");
        Block block = receiver.getTargetBlock(null, range);
        if (!block.getType().equals((Object)Material.AIR)) {
            Location loc = block.getLocation();
            loc.add(0.0, 1.0, 0.0);
            EntityType toSpawnEntityType = entityBuilder.getEntityType();
            EntityType lightning = SCore.is1v20v5Plus() ? EntityType.LIGHTNING_BOLT : EntityType.valueOf((String)"LIGHTNING");
            for (int i = 0; i < amount; ++i) {
                if (toSpawnEntityType != null && toSpawnEntityType.equals((Object)lightning)) {
                    receiver.getWorld().strikeLightning(loc);
                    continue;
                }
                Entity e = entityBuilder.buildEntity(loc);
                if (toSpawnEntityType == null || !toSpawnEntityType.equals((Object)EntityType.FIREBALL)) continue;
                e.setVelocity(new Vector(0, 0, 0));
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("SPAWN_ENTITY_ON_CURSOR");
        names.add("SPAWNENTITYONCURSOR");
        return names;
    }

    @Override
    public String getTemplate() {
        return "SPAWN_ENTITY_ON_CURSOR entity:ZOMBIE amount:1 maxRange:200";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

