/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.config;

import com.ssomar.score.SCore;
import com.ssomar.score.config.Config;
import com.ssomar.score.config.Locale;
import com.ssomar.score.configs.messages.MessageMain;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.utils.logging.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;

public class GeneralConfig
extends Config {
    private static GeneralConfig instance;
    private Locale locale;
    private boolean useMySQL;
    private String dbIP;
    private int dbPort;
    private String dbName;
    private String dbUser;
    private String dbPassword;
    private String configVerbosity;
    private List<String> silenceOutputs;
    private List<String> globalSilenceOutputs;
    private boolean reduceDamageIndicatorWithProtolcolLib;
    private boolean debugCheckDamages;
    private boolean loopKillMode;
    private boolean enableDetectionEntitiesFromSpawner;
    private boolean disableCustomMetadataOnEntities;
    private boolean enableCommentsInConfig;
    private boolean selfHostPackDebug;
    private String selfHostPackIp;
    private String hologramsPlugin = "NONE";

    public GeneralConfig() {
        super("config.yml");
        super.setup(SCore.dataFolder, SCore.classLoader, null);
    }

    public static GeneralConfig getInstance() {
        if (instance == null) {
            instance = new GeneralConfig();
        }
        return instance;
    }

    public void reload() {
        super.setup((Plugin)SCore.plugin);
    }

    @Override
    public boolean converter(FileConfiguration config) {
        return false;
    }

    @Override
    public void load() {
        try {
            this.locale = Locale.valueOf(this.config.getString("locale", "EN").toUpperCase());
        }
        catch (IllegalArgumentException e) {
            SCore.plugin.getServer().getLogger().severe("[SCore] Invalid locale name: " + this.config.getString("locale") + ", using default locale: EN");
            this.locale = Locale.EN;
        }
        Utils.sendConsoleMsg("&eSCore &7Locale setup: &6" + (Object)((Object)this.locale));
        this.useMySQL = this.config.getBoolean("useMySQL", false);
        this.dbIP = this.config.getString("dbIP", "");
        this.dbPort = this.config.getInt("dbPort", 3306);
        this.dbName = this.config.getString("dbName", "");
        this.dbUser = this.config.getString("dbUser", "");
        this.dbPassword = this.config.getString("dbPassword", "");
        this.configVerbosity = this.config.getString("configVerbosity", "NORMAL");
        this.reduceDamageIndicatorWithProtolcolLib = this.config.getBoolean("reduceDamageIndicatorWithProtolcolLib", false);
        this.silenceOutputs = this.config.getStringList("silenceOutputs");
        this.globalSilenceOutputs = this.config.getStringList("globalSilenceOutputs");
        this.debugCheckDamages = this.config.getBoolean("debugCheckDamages", false);
        this.enableDetectionEntitiesFromSpawner = this.config.getBoolean("enableDetectionEntitiesFromSpawner", true);
        this.loopKillMode = this.config.getBoolean("loopKillMode", false);
        this.disableCustomMetadataOnEntities = this.config.getBoolean("disableCustomMetadataOnEntities", false);
        this.enableCommentsInConfig = this.config.getBoolean("enableCommentsInConfig", true) && SCore.is1v19Plus();
        this.selfHostPackDebug = this.config.getBoolean("selfHostPackDebug", false);
        this.selfHostPackIp = this.config.getString("selfHostPackIp", "");
        this.hologramsPlugin = this.config.getString("hologramsPlugin", "NONE").toUpperCase();
    }

    public boolean isVerbosityNormal() {
        return this.configVerbosity.equalsIgnoreCase("NORMAL");
    }

    public boolean isVerbosityMinimal() {
        return this.configVerbosity.toUpperCase().startsWith("MIN");
    }

    public boolean isVerbosityMaximal() {
        return this.configVerbosity.toUpperCase().startsWith("MAX");
    }

    public void nextLocale() {
        int next = (this.locale.ordinal() + 1) % Locale.values().length;
        this.locale = Locale.values()[next];
        this.config.set("locale", (Object)this.locale.name());
        this.save();
        FeatureSettingsSCore.reload();
        MessageMain.getInstance().reload();
        TM.getInstance().reload();
    }

    public void previousLocale() {
        int previous = (this.locale.ordinal() - 1 + Locale.values().length) % Locale.values().length;
        this.locale = Locale.values()[previous];
        this.config.set("locale", (Object)this.locale.name());
        this.save();
        FeatureSettingsSCore.reload();
        MessageMain.getInstance().reload();
        TM.getInstance().reload();
    }

    public String[] getAvailableLocales(String ... strings) {
        ArrayList<String> locales = new ArrayList<String>(Arrays.asList(strings));
        for (Locale locale : Locale.values()) {
            if (this.locale != locale) {
                locales.add("&6\u27a4 &7" + locale.name() + " &e- &7" + locale.getName());
                continue;
            }
            locales.add("&2\u27a4 &7&o" + locale.name() + " &a- &7&o" + locale.getName());
        }
        return locales.toArray(new String[0]);
    }

    @Generated
    public Locale getLocale() {
        return this.locale;
    }

    @Generated
    public boolean isUseMySQL() {
        return this.useMySQL;
    }

    @Generated
    public String getDbIP() {
        return this.dbIP;
    }

    @Generated
    public int getDbPort() {
        return this.dbPort;
    }

    @Generated
    public String getDbName() {
        return this.dbName;
    }

    @Generated
    public String getDbUser() {
        return this.dbUser;
    }

    @Generated
    public String getDbPassword() {
        return this.dbPassword;
    }

    @Generated
    public String getConfigVerbosity() {
        return this.configVerbosity;
    }

    @Generated
    public List<String> getSilenceOutputs() {
        return this.silenceOutputs;
    }

    @Generated
    public List<String> getGlobalSilenceOutputs() {
        return this.globalSilenceOutputs;
    }

    @Generated
    public boolean isReduceDamageIndicatorWithProtolcolLib() {
        return this.reduceDamageIndicatorWithProtolcolLib;
    }

    @Generated
    public boolean isDebugCheckDamages() {
        return this.debugCheckDamages;
    }

    @Generated
    public boolean isLoopKillMode() {
        return this.loopKillMode;
    }

    @Generated
    public boolean isEnableDetectionEntitiesFromSpawner() {
        return this.enableDetectionEntitiesFromSpawner;
    }

    @Generated
    public boolean isDisableCustomMetadataOnEntities() {
        return this.disableCustomMetadataOnEntities;
    }

    @Generated
    public boolean isEnableCommentsInConfig() {
        return this.enableCommentsInConfig;
    }

    @Generated
    public boolean isSelfHostPackDebug() {
        return this.selfHostPackDebug;
    }

    @Generated
    public String getSelfHostPackIp() {
        return this.selfHostPackIp;
    }

    @Generated
    public String getHologramsPlugin() {
        return this.hologramsPlugin;
    }
}

