/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.data;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.mixed_player_entity.commands.addtempattribute.AddTemporaryAttributeObject;
import com.ssomar.score.utils.logging.Utils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;

public class TemporaryAttributeQuery {
    private static final String TABLE_ID = "temp_attributes";
    private static final String COL_ATTRIBUTE_KEY = "attribute_key";
    private static final String COL_ENTITY_UUID = "entity_uuid";
    private static final String COL_ATTRIBUTE_TYPE = "attribute_type";
    private static final String COL_EXPIRY_TIME = "expiry_time";
    private static final String COL_AMOUNT = "amount";
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS temp_attributes (attribute_key VARCHAR(36) NOT NULL, attribute_type TEXT NOT NULL, amount DOUBLE NOT NULL, entity_uuid VARCHAR(36) NOT NULL, expiry_time BIGINT NOT NULL, PRIMARY KEY (attribute_key));";

    public static void createNewTable(Connection conn) {
        Statement statement = null;
        try {
            statement = conn.createStatement();
            Utils.sendConsoleMsg("&eSCore &7Creating table &6ATemporaryAttributesQuery &7if not exists...");
            statement.execute(CREATE_TABLE);
        }
        catch (SQLException e) {
            SCore.plugin.getLogger().severe("ERROR WHILE CREATING TABLE temp_attributes IN DATABASE: " + e.getMessage());
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insertToRecords(Connection conn, String attribute_key, String attribute_type, double amount, String entity_uuid, long expiry_time) {
        String insertQuery = "INSERT INTO temp_attributes (attribute_key,attribute_type,amount,entity_uuid,expiry_time) VALUES (?, ?, ?, ?, ?);";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("INSERT INTO temp_attributes (attribute_key,attribute_type,amount,entity_uuid,expiry_time) VALUES (?, ?, ?, ?, ?);");
            stmt.setString(1, attribute_key);
            stmt.setString(2, attribute_type);
            stmt.setDouble(3, amount);
            stmt.setString(4, entity_uuid);
            stmt.setLong(5, expiry_time);
            stmt.execute();
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("There was complication with the insert query for TemporaryAttributeQuery.java: " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<AddTemporaryAttributeObject> fetchExpiredTemporaryAttributes(Connection conn, String entityUUID) {
        ArrayList<AddTemporaryAttributeObject> returnArray = new ArrayList<AddTemporaryAttributeObject>();
        long currentTime = System.currentTimeMillis();
        String selectQuery = "SELECT * FROM temp_attributes WHERE entity_uuid=? AND expiry_time<?;";
        PreparedStatement stmt = null;
        ResultSet rset = null;
        try {
            stmt = conn.prepareStatement("SELECT * FROM temp_attributes WHERE entity_uuid=? AND expiry_time<?;");
            stmt.setString(1, entityUUID);
            stmt.setLong(2, currentTime);
            rset = stmt.executeQuery();
            while (rset.next()) {
                returnArray.add(new AddTemporaryAttributeObject(rset.getString(1), rset.getString(2), rset.getDouble(3), rset.getString(4), rset.getLong(5)));
            }
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("There was complication with the select query for TemporaryAttributeQuery.java: " + e.getMessage());
        }
        finally {
            if (rset != null) {
                try {
                    rset.close();
                }
                catch (Exception exception) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
        return returnArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteExpiredTemporaryAttributes(Connection conn, String entityUUID) {
        long currentTime = System.currentTimeMillis();
        String deleteQuery = "DELETE FROM temp_attributes WHERE entity_uuid=? AND expiry_time<?;";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM temp_attributes WHERE entity_uuid=? AND expiry_time<?;");
            stmt.setString(1, entityUUID);
            stmt.setLong(2, currentTime);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("There was complication with the delete query for TemporaryAttributeQuery.java: " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFromRecords(Connection conn, String key_attr) {
        String deleteQuery = "DELETE FROM temp_attributes WHERE attribute_key=?;";
        PreparedStatement stmt = null;
        try {
            stmt = conn.prepareStatement("DELETE FROM temp_attributes WHERE attribute_key=?;");
            stmt.setString(1, key_attr);
            stmt.executeUpdate();
        }
        catch (Exception e) {
            SCore.plugin.getLogger().warning("There was complication with the delete operation for TemporaryAttributeQuery.java: " + e.getMessage());
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

