/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.world.parent;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.world.WorldConditionFeature;
import com.ssomar.score.features.custom.conditions.world.WorldConditionRequest;
import com.ssomar.score.features.custom.conditions.world.condition.IfWeather;
import com.ssomar.score.features.custom.conditions.world.condition.IfWorldTime;
import com.ssomar.score.features.custom.conditions.world.parent.WorldConditionsFeatureEditor;
import com.ssomar.score.features.custom.conditions.world.parent.WorldConditionsFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.World;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldConditionsFeature
extends FeatureWithHisOwnEditor<WorldConditionsFeature, WorldConditionsFeature, WorldConditionsFeatureEditor, WorldConditionsFeatureEditorManager> {
    private List<WorldConditionFeature> conditions;

    public WorldConditionsFeature(FeatureParentInterface parent, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.reset();
    }

    @Override
    public void reset() {
        this.conditions = new ArrayList<WorldConditionFeature>();
        this.conditions.add(new IfWeather(this));
        this.conditions.add(new IfWorldTime(this));
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            for (WorldConditionFeature condition : this.conditions) {
                error.addAll(condition.load(plugin, section, isPremiumLoading));
            }
        }
        return error;
    }

    public boolean verifConditions(World world, Optional<Player> playerOpt, SendMessage messageSender, @Nullable Event event) {
        WorldConditionRequest request = new WorldConditionRequest(world, playerOpt, messageSender.getSp(), event);
        for (WorldConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            if (messageSender != null && playerOpt.isPresent()) {
                for (String error : request.getErrorsFinal()) {
                    messageSender.sendMessage(playerOpt.get(), error);
                }
            }
            return false;
        }
        return true;
    }

    public boolean verifConditions(World world, List<String> errors, @Nullable StringPlaceholder stringPlaceholder) {
        if (stringPlaceholder == null) {
            stringPlaceholder = new StringPlaceholder();
        }
        WorldConditionRequest request = new WorldConditionRequest(world, Optional.empty(), stringPlaceholder, null);
        for (WorldConditionFeature condition : this.conditions) {
            if (condition.verifCondition(request)) continue;
            errors.addAll(request.getErrorsFinal());
            return false;
        }
        return true;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        for (WorldConditionFeature condition : this.conditions) {
            condition.save(section);
        }
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public WorldConditionsFeature getValue() {
        return this;
    }

    @Override
    public WorldConditionsFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = "&7World condition(s) enabled: &e" + this.getWorldConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    public int getWorldConditionEnabledCount() {
        int i = 0;
        for (WorldConditionFeature condition : this.conditions) {
            if (!condition.hasCondition()) continue;
            ++i;
        }
        return i;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public WorldConditionsFeature clone(FeatureParentInterface newParent) {
        WorldConditionsFeature clone = new WorldConditionsFeature(newParent, this.getFeatureSettings());
        ArrayList<WorldConditionFeature> clones = new ArrayList<WorldConditionFeature>();
        for (WorldConditionFeature condition : this.conditions) {
            clones.add((WorldConditionFeature)condition.clone(clone));
        }
        clone.setConditions(clones);
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.conditions);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof WorldConditionsFeature) || !feature.getName().equals(this.getName())) continue;
            WorldConditionsFeature bCF = (WorldConditionsFeature)feature;
            ArrayList<WorldConditionFeature> clones = new ArrayList<WorldConditionFeature>();
            for (WorldConditionFeature condition : this.conditions) {
                clones.add(condition);
            }
            bCF.setConditions(clones);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        WorldConditionsFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public List<WorldConditionFeature> getConditions() {
        return this.conditions;
    }

    @Generated
    public void setConditions(List<WorldConditionFeature> conditions) {
        this.conditions = conditions;
    }
}

