/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.displayConditions;

import com.ssomar.executableitems.executableitems.ExecutableItemObject;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.conditions.item.parent.ItemConditionsFeature;
import com.ssomar.score.features.custom.conditions.placeholders.group.PlaceholderConditionGroupFeature;
import com.ssomar.score.features.custom.conditions.player.parent.PlayerConditionsFeature;
import com.ssomar.score.features.custom.conditions.world.parent.WorldConditionsFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DisplayConditionsFeatures
extends FeatureWithHisOwnEditor<DisplayConditionsFeatures, DisplayConditionsFeatures, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private BooleanFeature enableFeature;
    private PlayerConditionsFeature playerConditions;
    private WorldConditionsFeature worldConditions;
    private ItemConditionsFeature itemConditions;
    private PlaceholderConditionGroupFeature placeholderConditions;

    public DisplayConditionsFeatures(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.displayConditions);
        this.reset();
    }

    @Override
    public void reset() {
        this.enableFeature = new BooleanFeature(this, false, FeatureSettingsSCore.enableFeature);
        this.playerConditions = new PlayerConditionsFeature(this, FeatureSettingsSCore.playerConditions);
        this.worldConditions = new WorldConditionsFeature(this, FeatureSettingsSCore.worldConditions);
        this.itemConditions = new ItemConditionsFeature(this, FeatureSettingsSCore.itemConditions);
        this.placeholderConditions = new PlaceholderConditionGroupFeature(this);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection section = config.getConfigurationSection(this.getName());
            errors.addAll(this.playerConditions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.worldConditions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.itemConditions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.placeholderConditions.load(plugin, section, isPremiumLoading));
            errors.addAll(this.enableFeature.load(plugin, section, isPremiumLoading));
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection section = config.createSection(this.getName());
        this.playerConditions.save(section);
        this.worldConditions.save(section);
        this.itemConditions.save(section);
        this.placeholderConditions.save(section);
        this.enableFeature.save(section);
        if (this.isSavingOnlyIfDiffDefault() && section.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public DisplayConditionsFeatures getValue() {
        return this;
    }

    @Override
    public DisplayConditionsFeatures initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 6];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 6] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 5] = this.enableFeature.getValue() != false ? "&7Enabled: &a&l\u2714" : "&7Enabled: &c&l\u2718";
        finalDescription[finalDescription.length - 4] = "&7Player Conditions: &e" + this.playerConditions.getPlayerConditionEnabledCount();
        finalDescription[finalDescription.length - 3] = "&7World Conditions: &e" + this.worldConditions.getWorldConditionEnabledCount();
        finalDescription[finalDescription.length - 2] = "&7Item Conditions: &e" + this.itemConditions.getItemConditionEnabledCount();
        finalDescription[finalDescription.length - 1] = "&7Placeholder Conditions: &e" + this.placeholderConditions.getPlaceholdersConditions().size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    public boolean verify(Player player, ExecutableItemObject eiO, List<String> errors) {
        boolean result = true;
        if (!this.enableFeature.getValue().booleanValue()) {
            return true;
        }
        StringPlaceholder sp = new StringPlaceholder();
        sp.setPlayerPlcHldr(player.getUniqueId());
        sp.setVariables(eiO.getInternalData().getVariableRealsList());
        result = this.playerConditions.verifConditions(player, errors, sp) && result;
        result = this.worldConditions.verifConditions(player.getWorld(), errors, sp) && result;
        result = this.itemConditions.verifConditions(eiO.getItem(), errors, sp) && result;
        result = this.placeholderConditions.verifConditions(player, errors) && result;
        return result;
    }

    @Override
    public DisplayConditionsFeatures clone(FeatureParentInterface newParent) {
        DisplayConditionsFeatures dropFeatures = new DisplayConditionsFeatures(newParent);
        dropFeatures.playerConditions = this.playerConditions.clone(dropFeatures);
        dropFeatures.worldConditions = this.worldConditions.clone(dropFeatures);
        dropFeatures.itemConditions = this.itemConditions.clone(dropFeatures);
        dropFeatures.placeholderConditions = this.placeholderConditions.clone(dropFeatures);
        dropFeatures.enableFeature = this.enableFeature.clone(dropFeatures);
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enableFeature);
        features.add(this.playerConditions);
        features.add(this.worldConditions);
        features.add(this.itemConditions);
        features.add(this.placeholderConditions);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof DisplayConditionsFeatures)) continue;
            DisplayConditionsFeatures hiders = (DisplayConditionsFeatures)feature;
            hiders.setPlayerConditions(this.playerConditions);
            hiders.setWorldConditions(this.worldConditions);
            hiders.setItemConditions(this.itemConditions);
            hiders.setPlaceholderConditions(this.placeholderConditions);
            hiders.setEnableFeature(this.enableFeature);
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public BooleanFeature getEnableFeature() {
        return this.enableFeature;
    }

    @Generated
    public PlayerConditionsFeature getPlayerConditions() {
        return this.playerConditions;
    }

    @Generated
    public WorldConditionsFeature getWorldConditions() {
        return this.worldConditions;
    }

    @Generated
    public ItemConditionsFeature getItemConditions() {
        return this.itemConditions;
    }

    @Generated
    public PlaceholderConditionGroupFeature getPlaceholderConditions() {
        return this.placeholderConditions;
    }

    @Generated
    public void setEnableFeature(BooleanFeature enableFeature) {
        this.enableFeature = enableFeature;
    }

    @Generated
    public void setPlayerConditions(PlayerConditionsFeature playerConditions) {
        this.playerConditions = playerConditions;
    }

    @Generated
    public void setWorldConditions(WorldConditionsFeature worldConditions) {
        this.worldConditions = worldConditions;
    }

    @Generated
    public void setItemConditions(ItemConditionsFeature itemConditions) {
        this.itemConditions = itemConditions;
    }

    @Generated
    public void setPlaceholderConditions(PlaceholderConditionGroupFeature placeholderConditions) {
        this.placeholderConditions = placeholderConditions;
    }
}

