/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.enchantments.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.enchantments.enchantment.EnchantmentWithLevelFeature;
import com.ssomar.score.features.custom.enchantments.group.EnchantmentsGroupFeatureEditor;
import com.ssomar.score.features.custom.enchantments.group.EnchantmentsGroupFeatureEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public class EnchantmentsGroupFeature
extends FeatureWithHisOwnEditor<EnchantmentsGroupFeature, EnchantmentsGroupFeature, EnchantmentsGroupFeatureEditor, EnchantmentsGroupFeatureEditorManager>
implements FeaturesGroup<EnchantmentWithLevelFeature>,
SProjectileFeatureInterface {
    private Map<String, EnchantmentWithLevelFeature> enchantments;
    private boolean notSaveIfNoValue;

    public EnchantmentsGroupFeature(FeatureParentInterface parent, boolean notSaveIfNoValue) {
        super(parent, FeatureSettingsSCore.enchantments);
        this.notSaveIfNoValue = notSaveIfNoValue;
        this.reset();
    }

    @Override
    public void reset() {
        this.enchantments = new HashMap<String, EnchantmentWithLevelFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String enchantmentID : enchantmentsSection.getKeys(false)) {
                EnchantmentWithLevelFeature enchantment = new EnchantmentWithLevelFeature((FeatureParentInterface)this, enchantmentID);
                List<String> subErrors = enchantment.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.enchantments.put(enchantmentID, enchantment);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        if (this.notSaveIfNoValue && this.enchantments.size() == 0) {
            return;
        }
        ConfigurationSection enchantmentsSection = config.createSection(this.getName());
        for (String enchantmentID : this.enchantments.keySet()) {
            this.enchantments.get(enchantmentID).save(enchantmentsSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && enchantmentsSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public EnchantmentsGroupFeature getValue() {
        return this;
    }

    @Override
    public EnchantmentsGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oEnchantment(s) added: &e" + this.enchantments.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public EnchantmentWithLevelFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (EnchantmentWithLevelFeature x : this.enchantments.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public EnchantmentsGroupFeature clone(FeatureParentInterface newParent) {
        EnchantmentsGroupFeature eF = new EnchantmentsGroupFeature(newParent, this.isNotSaveIfNoValue());
        HashMap<String, EnchantmentWithLevelFeature> newEnchantments = new HashMap<String, EnchantmentWithLevelFeature>();
        for (String x : this.enchantments.keySet()) {
            newEnchantments.put(x, this.enchantments.get(x).clone(eF));
        }
        eF.setEnchantments(newEnchantments);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.enchantments.values());
    }

    @Override
    public String getParentInfo() {
        if (this.getParent() == this) {
            return "";
        }
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof EnchantmentsGroupFeature)) continue;
            EnchantmentsGroupFeature eF = (EnchantmentsGroupFeature)feature;
            eF.setEnchantments(this.getEnchantments());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        EnchantmentsGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "enchantment";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.enchantments.containsKey(id)) continue;
            EnchantmentWithLevelFeature eF = new EnchantmentWithLevelFeature((FeatureParentInterface)this, id);
            this.enchantments.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, EnchantmentWithLevelFeature feature) {
        this.enchantments.remove(feature.getId());
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (e instanceof Trident) {
            Trident t = (Trident)e;
            try {
                ItemStack item = t.getItem();
                ItemMeta meta = item.getItemMeta();
                for (EnchantmentWithLevelFeature eF : this.enchantments.values()) {
                    meta.addEnchant((Enchantment)((Optional)eF.getEnchantment().getValue()).get(), ((Integer)((Optional)eF.getLevel().getValue()).get()).intValue(), true);
                }
                item.setItemMeta(meta);
                t.setItem(item);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    @Generated
    public Map<String, EnchantmentWithLevelFeature> getEnchantments() {
        return this.enchantments;
    }

    @Generated
    public boolean isNotSaveIfNoValue() {
        return this.notSaveIfNoValue;
    }

    @Generated
    public void setEnchantments(Map<String, EnchantmentWithLevelFeature> enchantments) {
        this.enchantments = enchantments;
    }

    @Generated
    public void setNotSaveIfNoValue(boolean notSaveIfNoValue) {
        this.notSaveIfNoValue = notSaveIfNoValue;
    }
}

