/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.parent;

import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.custom.required.executableitems.group.RequiredExecutableItemGroupFeature;
import com.ssomar.score.features.custom.required.experience.RequiredExperience;
import com.ssomar.score.features.custom.required.items.group.RequiredItemGroupFeature;
import com.ssomar.score.features.custom.required.level.RequiredLevel;
import com.ssomar.score.features.custom.required.magic.group.RequiredMagicGroupFeature;
import com.ssomar.score.features.custom.required.mana.RequiredMana;
import com.ssomar.score.features.custom.required.money.RequiredMoney;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RequiredGroup
extends FeatureWithHisOwnEditor<RequiredGroup, RequiredGroup, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements RequiredPlayerInterface {
    private static final Boolean DEBUG = false;
    private RequiredLevel requiredLevel;
    private RequiredExperience requiredExperience;
    private RequiredMoney requiredMoney;
    private RequiredItemGroupFeature requiredItems;
    private RequiredExecutableItemGroupFeature requiredExecutableItems;
    private RequiredMana requiredMana;
    private RequiredMagicGroupFeature requiredMagics;

    public RequiredGroup(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.requiredGroups);
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        error.addAll(this.requiredLevel.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredExperience.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredMoney.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredItems.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredExecutableItems.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredMana.load(plugin, config, isPremiumLoading));
        error.addAll(this.requiredMagics.load(plugin, config, isPremiumLoading));
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        this.requiredLevel.save(config);
        this.requiredExperience.save(config);
        this.requiredMoney.save(config);
        this.requiredItems.save(config);
        this.requiredExecutableItems.save(config);
        this.requiredMana.save(config);
        this.requiredMagics.save(config);
        if (this.isSavingOnlyIfDiffDefault() && config.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        if (!this.requiredLevel.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid level", DEBUG);
            return false;
        }
        if (!this.requiredExperience.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid experience", DEBUG);
            return false;
        }
        if (!this.requiredMoney.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid money", DEBUG);
            return false;
        }
        if (!this.requiredItems.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid items", DEBUG);
            return false;
        }
        if (!this.requiredExecutableItems.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid executable items", DEBUG);
            return false;
        }
        if (!this.requiredMana.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid mana", DEBUG);
            return false;
        }
        if (!this.requiredMagics.verify(player, event, sp)) {
            SsomarDev.testMsg("Invalid magics", DEBUG);
            return false;
        }
        return true;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        SsomarDev.testMsg("Taking required things", DEBUG);
        this.requiredLevel.take(player, sp);
        this.requiredExperience.take(player, sp);
        this.requiredMoney.take(player, sp);
        this.requiredItems.take(player, sp);
        this.requiredExecutableItems.take(player, sp);
        this.requiredMana.take(player, sp);
        this.requiredMagics.take(player, sp);
    }

    @Override
    public RequiredGroup getValue() {
        return this;
    }

    @Override
    public RequiredGroup initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 8];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 8] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 7] = (Integer)((Optional)this.requiredLevel.getValue().getLevel().getValue()).get() > 0 ? "&7Required level: &a&l\u2714" : "&7Required level: &c&l\u2718";
        finalDescription[finalDescription.length - 6] = (Integer)((Optional)this.requiredExperience.getValue().getExperience().getValue()).get() > 0 ? "&7Required experience: &a&l\u2714" : "&7Required experience: &c&l\u2718";
        finalDescription[finalDescription.length - 5] = (Double)((Optional)this.requiredMoney.getValue().getMoney().getValue()).get() > 0.0 ? "&7Required money: &a&l\u2714" : "&7Required money: &c&l\u2718";
        finalDescription[finalDescription.length - 4] = this.requiredItems.getValue().getRequiredItems().size() > 0 ? "&7Required items: &a&l\u2714" : "&7Required items: &c&l\u2718";
        finalDescription[finalDescription.length - 3] = this.requiredExecutableItems.getValue().getRequiredExecutableItems().size() > 0 ? "&7Required executable items: &a&l\u2714" : "&7Required executable items: &c&l\u2718";
        finalDescription[finalDescription.length - 2] = (Integer)((Optional)this.requiredMana.getValue().getMana().getValue()).get() > 0 ? "&7Required mana: &a&l\u2714" : "&7Required mana: &c&l\u2718";
        finalDescription[finalDescription.length - 1] = this.requiredMagics.getValue().getRequiredMagics().size() > 0 ? "&7Required magics: &a&l\u2714" : "&7Required magics: &c&l\u2718";
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredGroup clone(FeatureParentInterface newParent) {
        RequiredGroup requiredGroup = new RequiredGroup(newParent);
        requiredGroup.setRequiredLevel(this.getRequiredLevel().clone(requiredGroup));
        requiredGroup.setRequiredExperience(this.getRequiredExperience().clone(requiredGroup));
        requiredGroup.setRequiredMoney(this.getRequiredMoney().clone(requiredGroup));
        requiredGroup.setRequiredItems(this.getRequiredItems().clone(requiredGroup));
        requiredGroup.setRequiredExecutableItems(this.getRequiredExecutableItems().clone(requiredGroup));
        requiredGroup.setRequiredMana(this.getRequiredMana().clone(requiredGroup));
        requiredGroup.setRequiredMagics(this.getRequiredMagics().clone(requiredGroup));
        return requiredGroup;
    }

    @Override
    public void reset() {
        this.requiredLevel = new RequiredLevel(this);
        this.requiredExperience = new RequiredExperience(this);
        this.requiredMoney = new RequiredMoney(this);
        this.requiredItems = new RequiredItemGroupFeature(this);
        this.requiredExecutableItems = new RequiredExecutableItemGroupFeature(this);
        this.requiredMana = new RequiredMana(this);
        this.requiredMagics = new RequiredMagicGroupFeature(this);
    }

    @Override
    public void openEditor(Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return Arrays.asList(this.requiredLevel, this.requiredExperience, this.requiredMoney, this.requiredItems, this.requiredExecutableItems, this.requiredMana, this.requiredMagics);
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        return this.getParent().getConfigurationSection();
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RequiredGroup)) continue;
            RequiredGroup requiredgroup = (RequiredGroup)feature;
            requiredgroup.setRequiredLevel(this.requiredLevel);
            requiredgroup.setRequiredExperience(this.requiredExperience);
            requiredgroup.setRequiredMoney(this.requiredMoney);
            requiredgroup.setRequiredItems(this.requiredItems);
            requiredgroup.setRequiredExecutableItems(this.requiredExecutableItems);
            requiredgroup.setRequiredMana(this.requiredMana);
            requiredgroup.setRequiredMagics(this.requiredMagics);
            break;
        }
    }

    @Generated
    public RequiredLevel getRequiredLevel() {
        return this.requiredLevel;
    }

    @Generated
    public RequiredExperience getRequiredExperience() {
        return this.requiredExperience;
    }

    @Generated
    public RequiredMoney getRequiredMoney() {
        return this.requiredMoney;
    }

    @Generated
    public RequiredItemGroupFeature getRequiredItems() {
        return this.requiredItems;
    }

    @Generated
    public RequiredExecutableItemGroupFeature getRequiredExecutableItems() {
        return this.requiredExecutableItems;
    }

    @Generated
    public RequiredMana getRequiredMana() {
        return this.requiredMana;
    }

    @Generated
    public RequiredMagicGroupFeature getRequiredMagics() {
        return this.requiredMagics;
    }

    @Generated
    public void setRequiredLevel(RequiredLevel requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    @Generated
    public void setRequiredExperience(RequiredExperience requiredExperience) {
        this.requiredExperience = requiredExperience;
    }

    @Generated
    public void setRequiredMoney(RequiredMoney requiredMoney) {
        this.requiredMoney = requiredMoney;
    }

    @Generated
    public void setRequiredItems(RequiredItemGroupFeature requiredItems) {
        this.requiredItems = requiredItems;
    }

    @Generated
    public void setRequiredExecutableItems(RequiredExecutableItemGroupFeature requiredExecutableItems) {
        this.requiredExecutableItems = requiredExecutableItems;
    }

    @Generated
    public void setRequiredMana(RequiredMana requiredMana) {
        this.requiredMana = requiredMana;
    }

    @Generated
    public void setRequiredMagics(RequiredMagicGroupFeature requiredMagics) {
        this.requiredMagics = requiredMagics;
    }
}

