/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.variables.real;

import com.ssomar.score.features.custom.variables.base.variable.VariableFeature;
import com.ssomar.score.features.custom.variables.update.variable.VariableUpdateFeature;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReaderManager;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.NamespacedKey;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VariableReal<T> {
    private VariableFeature config;
    private T value;
    private NamespacedKey key;
    private final ItemKeyWriterReader itemKeyWriterReader;

    public VariableReal(VariableFeature<T> config, ItemStack item, @NotNull DynamicMeta dMeta) {
        this.config = config;
        this.itemKeyWriterReader = ItemKeyWriterReaderManager.getInstance().getItemKeyWriterReader();
        Optional<T> optional = this.readValue(item, dMeta);
        this.value = optional.isPresent() ? optional.get() : config.getDefaultValue();
    }

    public VariableReal(VariableFeature<T> config, PersistentDataContainer dataContainer) {
        this.config = config;
        this.itemKeyWriterReader = ItemKeyWriterReaderManager.getInstance().getItemKeyWriterReader();
        Optional<T> optional = this.readValue(dataContainer);
        this.value = optional.isPresent() ? optional.get() : config.getDefaultValue();
    }

    public VariableReal(VariableFeature<T> config, ConfigurationSection configurationSection) {
        this.config = config;
        this.itemKeyWriterReader = ItemKeyWriterReaderManager.getInstance().getItemKeyWriterReader();
        Optional<T> optional = this.readValue(configurationSection);
        this.value = optional.isPresent() ? optional.get() : config.getDefaultValue();
    }

    public String toString() {
        return this.value.toString();
    }

    public abstract Optional<T> readValue(ItemStack var1, DynamicMeta var2);

    public abstract Optional<T> readValue(PersistentDataContainer var1);

    public abstract Optional<T> readValue(ConfigurationSection var1);

    public abstract void writeValue(ItemStack var1, DynamicMeta var2);

    public abstract void writeValue(PersistentDataContainer var1);

    public abstract void writeValue(ConfigurationSection var1);

    public abstract void modifVariable(ItemStack var1, @NotNull DynamicMeta var2, VariableUpdateFeature var3, @Nullable Player var4, @Nullable StringPlaceholder var5);

    public abstract void modifVariable(PersistentDataContainer var1, VariableUpdateFeature var2, @Nullable Player var3, @Nullable StringPlaceholder var4);

    public abstract void modifVariable(@NotNull ConfigurationSection var1, VariableUpdateFeature var2, @Nullable Player var3, @Nullable StringPlaceholder var4);

    public abstract String replaceVariablePlaceholder(String var1);

    public abstract String replaceVariablePlaceholder(String var1, boolean var2);

    public abstract String getPlaceholderWithTag(String var1);

    @Generated
    public VariableFeature getConfig() {
        return this.config;
    }

    @Generated
    public T getValue() {
        return this.value;
    }

    @Generated
    public NamespacedKey getKey() {
        return this.key;
    }

    @Generated
    public ItemKeyWriterReader getItemKeyWriterReader() {
        return this.itemKeyWriterReader;
    }

    @Generated
    public void setValue(T value) {
        this.value = value;
    }
}

