/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectTypeFeature
extends FeatureAbstract<Optional<PotionEffectType>, PotionEffectTypeFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<PotionEffectType> value;
    private Optional<PotionEffectType> defaultValue;

    public PotionEffectTypeFeature(FeatureParentInterface parent, Optional<PotionEffectType> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            PotionEffectType attributeSlot = PotionEffectType.getByName((String)colorStr.toUpperCase());
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<PotionEffectType> checkPremium = this.checkPremium("PotionEffectType", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the PotionEffectType value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> List: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/potion/PotionEffectType.html");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        Object value = this.getValue();
        ((Optional)value).ifPresent(potionEffectType -> config.set(this.getName(), (Object)potionEffectType.getName()));
    }

    @Override
    public Optional<PotionEffectType> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public PotionEffectTypeFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        PotionEffectType finalValue = ((Optional)value).orElse(PotionEffectType.getByName((String)"HEAL"));
        this.updatePotionEffectType(finalValue, gui);
    }

    @Override
    public PotionEffectTypeFeature clone(FeatureParentInterface newParent) {
        PotionEffectTypeFeature clone = new PotionEffectTypeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        PotionEffectType slot = this.getPotionEffectType((GUI)manager.getCache().get(editor));
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        slot = this.nextPotionEffectType(slot);
        this.updatePotionEffectType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        PotionEffectType slot = this.getPotionEffectType((GUI)manager.getCache().get(editor));
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        slot = this.prevPotionEffectType(slot);
        this.updatePotionEffectType(slot, (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updatePotionEffectType(this.nextPotionEffectType(this.getPotionEffectType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updatePotionEffectType(this.prevPotionEffectType(this.getPotionEffectType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public PotionEffectType nextPotionEffectType(PotionEffectType slot) {
        boolean next = false;
        for (PotionEffectType check : this.getSortPotionEffectTypes()) {
            if (check.equals(slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortPotionEffectTypes().get(0);
    }

    public PotionEffectType prevPotionEffectType(PotionEffectType slot) {
        int i = -1;
        int cpt = 0;
        for (PotionEffectType check : this.getSortPotionEffectTypes()) {
            if (check.equals(slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortPotionEffectTypes().get(this.getSortPotionEffectTypes().size() - 1);
        }
        return this.getSortPotionEffectTypes().get(cpt - 1);
    }

    public void updatePotionEffectType(PotionEffectType slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortPotionEffectTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (PotionEffectType check : this.getSortPotionEffectTypes()) {
            if (slot.equals(check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.getName()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.getName()));
        }
        for (PotionEffectType check : this.getSortPotionEffectTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.getName()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public PotionEffectType getPotionEffectType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return PotionEffectType.getByName((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<PotionEffectType> getSortPotionEffectTypes() {
        TreeMap<String, PotionEffectType> map = new TreeMap<String, PotionEffectType>();
        for (PotionEffectType l : PotionEffectType.values()) {
            if (l == null) continue;
            map.put(l.getName(), l);
        }
        return new ArrayList<PotionEffectType>(map.values());
    }

    @Generated
    public Optional<PotionEffectType> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<PotionEffectType> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<PotionEffectType> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

