/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types.list;

import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListFeatureAbstract;
import com.ssomar.score.menu.EditorCreator;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.GameMode;
import org.bukkit.entity.Player;

public class ListGameModeFeature
extends ListFeatureAbstract<GameMode, ListGameModeFeature> {
    public ListGameModeFeature(FeatureParentInterface parent, List<GameMode> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, "List of GameModes", defaultValue, featureSettings);
        this.reset();
    }

    @Override
    public List<GameMode> loadValues(List<String> entries, List<String> errors) {
        ArrayList<GameMode> val2 = new ArrayList<GameMode>();
        for (String s : entries) {
            val2.add(GameMode.valueOf((String)s.toUpperCase()));
        }
        return val2;
    }

    @Override
    public String transfromToString(GameMode value) {
        return value.name();
    }

    @Override
    public ListGameModeFeature clone(FeatureParentInterface newParent) {
        ListGameModeFeature clone = new ListGameModeFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.setValues(this.getValues());
        clone.setBlacklistedValues(this.getBlacklistedValues());
        return clone;
    }

    @Override
    public Optional<String> verifyMessage(String message) {
        message = StringConverter.decoloredString(message).trim();
        try {
            GameMode.valueOf((String)message.toUpperCase());
        }
        catch (Exception e) {
            return Optional.of("&cThis GameMode doesn't exist &7https://hub.spigotmc.org/javadocs/spigot/org/bukkit/GameMode.html");
        }
        return Optional.empty();
    }

    @Override
    public List<TextComponent> getMoreInfo() {
        return new ArrayList<TextComponent>();
    }

    @Override
    public List<Suggestion> getSuggestions() {
        return new ArrayList<Suggestion>();
    }

    @Override
    public String getTips() {
        return "";
    }

    @Override
    public void sendBeforeTextEditor(Player playerEditor, NewGUIManager manager) {
        ArrayList<String> beforeMenu = new ArrayList<String>();
        beforeMenu.add("&7\u27a4 Your custom " + this.getEditorName() + ":");
        HashMap<String, String> suggestions = new HashMap<String, String>();
        EditorCreator editor = new EditorCreator(beforeMenu, manager.currentWriting.get(playerEditor), this.getEditorName() + ":", true, true, true, true, true, true, false, "", suggestions);
        editor.generateTheMenuAndSendIt(playerEditor);
    }

    public boolean isValid(GameMode gameMode) {
        if (this.getBlacklistedValues() != null && this.getBlacklistedValues().contains(gameMode)) {
            return false;
        }
        return this.getValues() == null || this.getValues().isEmpty() || this.getValues().contains(gameMode);
    }
}

