/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.menu.particles;

import com.ssomar.score.menu.GUI;
import com.ssomar.score.menu.particles.SParticleGUI;
import com.ssomar.score.menu.particles.SParticlesGUIManager;
import com.ssomar.score.menu.score.GUIManagerSCore;
import com.ssomar.score.menu.score.InteractionClickedGUIManager;
import com.ssomar.score.sparticles.SParticle;
import com.ssomar.score.sparticles.SParticles;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class SParticleGUIManager
extends GUIManagerSCore<SParticleGUI> {
    private static SParticleGUIManager instance;

    public static SParticleGUIManager getInstance() {
        if (instance == null) {
            instance = new SParticleGUIManager();
        }
        return instance;
    }

    public void startEditing(Player p, SPlugin sPlugin, SParticles sParticles, GUI guiFrom) {
        this.cache.put(p, new SParticleGUI(sPlugin, sParticles, guiFrom));
        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
    }

    public void startEditing(Player p, SPlugin sPlugin, SParticles sParticles, SParticle sParticle, GUI guiFrom) {
        this.cache.put(p, new SParticleGUI(sPlugin, sParticles, sParticle, guiFrom));
        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
    }

    @Override
    public boolean allClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        if (i.name.contains("Particle Amount")) {
            this.requestWriting.put(i.player, "Particle Amount");
            i.player.closeInventory();
            this.space(i.player);
            i.player.sendMessage(StringConverter.coloredString("&a&l" + i.sPlugin.getNameDesign() + " &aEnter an amount (min 1):"));
            this.space(i.player);
        } else if (i.name.contains("Particle Delay")) {
            this.requestWriting.put(i.player, "Particle Delay");
            i.player.closeInventory();
            this.space(i.player);
            i.player.sendMessage(StringConverter.coloredString("&a&l" + i.sPlugin.getNameDesign() + " &aEnter a delay (min 1, in ticks):"));
            this.space(i.player);
        } else if (i.name.contains("Particle OffSet")) {
            this.requestWriting.put(i.player, "Particle OffSet");
            i.player.closeInventory();
            this.space(i.player);
            i.player.sendMessage(StringConverter.coloredString("&a&l" + i.sPlugin.getNameDesign() + " &aEnter the offset (range) of the particle (min 0.000001, Double):"));
            this.space(i.player);
        } else if (i.name.contains("Particle Speed")) {
            this.requestWriting.put(i.player, "Particle Speed");
            i.player.closeInventory();
            this.space(i.player);
            i.player.sendMessage(StringConverter.coloredString("&a&l" + i.sPlugin.getNameDesign() + " &aEnter a speed (min 0.000001, Double):"));
            this.space(i.player);
        }
        if (i.name.contains("Block type")) {
            this.requestWriting.put(i.player, "Block type");
            i.player.closeInventory();
            this.space(i.player);
            i.player.sendMessage(StringConverter.coloredString("&a&l &aEnter the material of the block particle:"));
            this.space(i.player);
        } else if (i.name.contains("Save") || i.name.contains("Create this particle")) {
            this.saveTheConfiguration(i.player);
            SParticles sParticles = ((SParticleGUI)this.cache.get(i.player)).getSParticles();
            GUI guiFrom = ((SParticleGUI)this.cache.get(i.player)).getGuiFrom();
            this.cache.remove(i.player);
            this.requestWriting.remove(i.player);
            SParticlesGUIManager.getInstance().startEditing(i.player, i.sPlugin, sParticles, guiFrom);
        } else if (i.name.contains("Back")) {
            SParticlesGUIManager.getInstance().startEditing(i.player, i.sPlugin, ((SParticleGUI)this.cache.get(i.player)).getSParticles(), ((SParticleGUI)this.cache.get(i.player)).getGuiFrom());
        } else {
            return false;
        }
        return true;
    }

    public void receivedMessage(Player p, String message) {
        boolean notExit = true;
        SPlugin sPlugin = ((SParticleGUI)this.cache.get(p)).getsPlugin();
        String plName = sPlugin.getNameDesign();
        if (((String)this.requestWriting.get(p)).equals("Particle Amount")) {
            boolean error = true;
            if (!message.replaceAll(" ", "").isEmpty()) {
                try {
                    if (Integer.parseInt(message) > 0) {
                        ((SParticleGUI)this.cache.get(p)).updateInt("Particle Amount", Integer.parseInt(message));
                        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
                        this.requestWriting.remove(p);
                        error = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (error) {
                p.sendMessage(StringConverter.coloredString("&c&l" + plName + " &cError invalid amount pls select an amount > 0 !"));
            }
        } else if (((String)this.requestWriting.get(p)).equals("Particle Delay")) {
            boolean error = true;
            if (!message.replaceAll(" ", "").isEmpty()) {
                try {
                    if (Integer.parseInt(message) > 0) {
                        ((SParticleGUI)this.cache.get(p)).updateInt("Particle Delay", Integer.parseInt(message));
                        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
                        this.requestWriting.remove(p);
                        error = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (error) {
                p.sendMessage(StringConverter.coloredString("&c&l" + plName + " &cError invalid amount pls select a delay > 0 !"));
            }
        } else if (((String)this.requestWriting.get(p)).equals("Particle Speed")) {
            boolean error = true;
            if (!message.replaceAll(" ", "").isEmpty()) {
                try {
                    if (Double.parseDouble(message) > 0.0) {
                        ((SParticleGUI)this.cache.get(p)).updateDouble("Particle Speed", Double.parseDouble(message));
                        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
                        this.requestWriting.remove(p);
                        error = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (error) {
                p.sendMessage(StringConverter.coloredString("&c&l" + plName + " &cError invalid amount pls select a speed > 0 !"));
            }
        } else if (((String)this.requestWriting.get(p)).equals("Particle OffSet")) {
            boolean error = true;
            if (!message.replaceAll(" ", "").isEmpty()) {
                try {
                    if (Double.parseDouble(message) > 0.0) {
                        ((SParticleGUI)this.cache.get(p)).updateDouble("Particle OffSet", Double.parseDouble(message));
                        ((SParticleGUI)this.cache.get(p)).openGUISync(p);
                        this.requestWriting.remove(p);
                        error = false;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (error) {
                p.sendMessage(StringConverter.coloredString("&c&l" + plName + " &cError invalid amount pls select an offset (range) > 0 !"));
            }
        } else if (((String)this.requestWriting.get(p)).equals("Block type")) {
            boolean error = true;
            if (!message.replaceAll(" ", "").isEmpty()) {
                try {
                    ((SParticleGUI)this.cache.get(p)).updateMaterial(Material.valueOf((String)StringConverter.decoloredString(message).trim().toUpperCase()));
                    ((SParticleGUI)this.cache.get(p)).openGUISync(p);
                    this.requestWriting.remove(p);
                    error = false;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (error) {
                p.sendMessage(StringConverter.coloredString("&c&l" + plName + " &cError invalid material pls select a good material !  https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html"));
            }
        }
    }

    @Override
    public void saveTheConfiguration(Player p) {
        SParticle sParticle = new SParticle(((SParticleGUI)this.cache.get(p)).getCurrently("ID:"));
        sParticle.setParticlesAmount(((SParticleGUI)this.cache.get(p)).getInt("Particle Amount"));
        sParticle.setParticlesDelay(((SParticleGUI)this.cache.get(p)).getInt("Particle Delay"));
        sParticle.setParticlesType(((SParticleGUI)this.cache.get(p)).getType());
        sParticle.setParticlesSpeed(((SParticleGUI)this.cache.get(p)).getDouble("Particle Speed"));
        sParticle.setParticlesOffSet(((SParticleGUI)this.cache.get(p)).getDouble("Particle OffSet"));
        if (sParticle.canHaveBlocktype()) {
            sParticle.setBlockType(((SParticleGUI)this.cache.get(p)).getMaterial());
        }
        if (sParticle.canHaveRedstoneColor()) {
            sParticle.setRedstoneColor(((SParticleGUI)this.cache.get(p)).getColor());
        }
        SParticles sParticles = ((SParticleGUI)this.cache.get(p)).getSParticles();
        sParticles.updateParticle(sParticle);
        sParticles.save();
    }

    @Override
    public boolean noShiftclicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean shiftClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        return false;
    }

    @Override
    public boolean leftClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        if (i.name.contains("Particle Type")) {
            ((SParticleGUI)this.cache.get(i.player)).updateType(((SParticleGUI)this.cache.get(i.player)).nextType(((SParticleGUI)this.cache.get(i.player)).getType()));
            return true;
        }
        if (i.name.contains("Redstone color")) {
            ((SParticleGUI)this.cache.get(i.player)).updateColor(((SParticleGUI)this.cache.get(i.player)).nextColor(((SParticleGUI)this.cache.get(i.player)).getColor()));
            return true;
        }
        return false;
    }

    @Override
    public boolean rightClicked(InteractionClickedGUIManager<SParticleGUI> i) {
        if (i.name.contains("Particle Type")) {
            ((SParticleGUI)this.cache.get(i.player)).updateType(((SParticleGUI)this.cache.get(i.player)).prevType(((SParticleGUI)this.cache.get(i.player)).getType()));
            return true;
        }
        if (i.name.contains("Redstone color")) {
            ((SParticleGUI)this.cache.get(i.player)).updateColor(((SParticleGUI)this.cache.get(i.player)).prevColor(((SParticleGUI)this.cache.get(i.player)).getColor()));
            return true;
        }
        return false;
    }
}

