/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject.menu;

import com.ssomar.score.api.executableitems.events.AddItemInPlayerInventoryEvent;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import lombok.Generated;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;

public abstract class SObjectsEditorAbstract<T extends SObject>
extends GUI {
    public static final int SOBJECT_PER_PAGE = 27;
    public static int index;
    private SPlugin sPlugin;
    private String title;
    private String deleteArg;
    private String createArg;
    private boolean giveButton = true;
    private boolean newButton = true;
    private boolean defaultObjectsButton = true;
    private boolean clickToEdit = true;
    private boolean deleteButton = true;
    private boolean languageButton = true;
    private boolean pathButton = true;
    private boolean hideCreation = false;
    private List<Predicate<T>> predicates = new ArrayList<Predicate<T>>();
    private Comparator<T> comparator = new Comparator<T>(){

        @Override
        public int compare(T o1, T o2) {
            return ((SObject)o1).getId().compareTo(((SObject)o2).getId());
        }
    };
    private SObjectManager<T> manager;

    public SObjectsEditorAbstract(SPlugin sPlugin, FeatureSettingsInterface settings, SObjectManager<T> manager) {
        super(settings, 45);
        this.sPlugin = sPlugin;
        index = 1;
        this.deleteArg = "delete";
        this.createArg = "create";
        this.manager = manager;
        this.initSettings();
    }

    public SObjectsEditorAbstract(SPlugin sPlugin, String title, SObjectManager<T> manager) {
        super(title, 45);
        this.sPlugin = sPlugin;
        this.title = title;
        index = 1;
        this.deleteArg = "delete";
        this.createArg = "create";
        this.manager = manager;
        this.initSettings();
    }

    public abstract void initSettings();

    @Override
    public abstract void load();

    public abstract SObjectWithFileLoader getLoader();

    public void goNextPage() {
        ++index;
        this.load();
    }

    public void goPreviousPage() {
        this.setTitle(this.title + PAGE + --index);
        this.load();
    }

    abstract void goToFolder(String var1);

    abstract void goBack();

    public void sendMessageCreate(Player p) {
        if (this.sPlugin.isLotOfWork() && this.manager.getLoadedObjects().size() >= this.getLoader().getMaxFreeObjects()) {
            p.sendMessage(StringConverter.coloredString("&4&l" + this.sPlugin.getNameDesign() + " " + TM.g(Text.EDITOR_PREMIUM_REQUIREPREMIUMTOADDMORE)));
        } else {
            p.closeInventory();
            p.chat("/" + this.sPlugin.getShortName().toLowerCase() + " " + this.createArg);
        }
    }

    public String getCurrentPath() {
        ItemStack item = this.getByIdentifier(StringConverter.decoloredString(TM.g(Text.EDITOR_PATH_NAME)));
        return this.getCurrently(item);
    }

    public void sendMessageDelete(String objectID, Player p) {
        p.sendMessage(StringConverter.coloredString(this.sPlugin.getNameDesign() + " " + TM.g(Text.EDITOR_DELETE_MESSAGE).replace("%object%", this.manager.getObjectName()) + ": &6" + objectID));
        TextComponent delete = new TextComponent(StringConverter.coloredString("&4&l[&c&l" + GUI.CLICK_TO_REMOVE + "&4&l]"));
        delete.setClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/" + this.sPlugin.getShortName().toLowerCase() + " " + this.deleteArg + " " + objectID + " confirm"));
        delete.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(StringConverter.coloredString(GUI.CLICK_TO_REMOVE + this.manager.getObjectName())).create()));
        p.spigot().sendMessage((BaseComponent)delete);
        p.updateInventory();
    }

    public void openEditorSObject(String objectID, Player p) {
        Optional<T> optional = this.manager.getObject(objectID);
        if (optional.isPresent()) {
            SObject sObject = (SObject)optional.get();
            sObject.openEditor(p);
        }
    }

    public void giveSObject(String objectID, Player p) {
        SObject sObject;
        if (!this.giveButton) {
            return;
        }
        Optional<T> optional = this.manager.getLoadedObjectWithID(objectID);
        if (optional.isPresent() && (sObject = (SObject)optional.get()) instanceof SObjectBuildable) {
            SObjectBuildable buildable = (SObjectBuildable)((Object)sObject);
            int firstEmptySlot = p.getInventory().firstEmpty();
            ItemStack itemStack = buildable.buildItem(1, Optional.of(p));
            p.getInventory().addItem(new ItemStack[]{itemStack});
            p.sendMessage(StringConverter.coloredString("&2&l" + this.sPlugin.getNameDesign() + " " + TM.g(Text.EDITOR_GIVE_RECEIVEDMESSAGE) + objectID));
            AddItemInPlayerInventoryEvent eventToCall = new AddItemInPlayerInventoryEvent(p, itemStack, firstEmptySlot);
            Bukkit.getPluginManager().callEvent((Event)eventToCall);
        }
    }

    @Generated
    public SPlugin getSPlugin() {
        return this.sPlugin;
    }

    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public String getDeleteArg() {
        return this.deleteArg;
    }

    @Generated
    public String getCreateArg() {
        return this.createArg;
    }

    @Generated
    public boolean isGiveButton() {
        return this.giveButton;
    }

    @Generated
    public boolean isNewButton() {
        return this.newButton;
    }

    @Generated
    public boolean isDefaultObjectsButton() {
        return this.defaultObjectsButton;
    }

    @Generated
    public boolean isClickToEdit() {
        return this.clickToEdit;
    }

    @Generated
    public boolean isDeleteButton() {
        return this.deleteButton;
    }

    @Generated
    public boolean isLanguageButton() {
        return this.languageButton;
    }

    @Generated
    public boolean isPathButton() {
        return this.pathButton;
    }

    @Generated
    public boolean isHideCreation() {
        return this.hideCreation;
    }

    @Generated
    public List<Predicate<T>> getPredicates() {
        return this.predicates;
    }

    @Generated
    public Comparator<T> getComparator() {
        return this.comparator;
    }

    @Generated
    public SObjectManager<T> getManager() {
        return this.manager;
    }

    @Generated
    public void setSPlugin(SPlugin sPlugin) {
        this.sPlugin = sPlugin;
    }

    @Generated
    public void setTitle(String title) {
        this.title = title;
    }

    @Generated
    public void setDeleteArg(String deleteArg) {
        this.deleteArg = deleteArg;
    }

    @Generated
    public void setCreateArg(String createArg) {
        this.createArg = createArg;
    }

    @Generated
    public void setGiveButton(boolean giveButton) {
        this.giveButton = giveButton;
    }

    @Generated
    public void setNewButton(boolean newButton) {
        this.newButton = newButton;
    }

    @Generated
    public void setDefaultObjectsButton(boolean defaultObjectsButton) {
        this.defaultObjectsButton = defaultObjectsButton;
    }

    @Generated
    public void setClickToEdit(boolean clickToEdit) {
        this.clickToEdit = clickToEdit;
    }

    @Generated
    public void setDeleteButton(boolean deleteButton) {
        this.deleteButton = deleteButton;
    }

    @Generated
    public void setLanguageButton(boolean languageButton) {
        this.languageButton = languageButton;
    }

    @Generated
    public void setPathButton(boolean pathButton) {
        this.pathButton = pathButton;
    }

    @Generated
    public void setHideCreation(boolean hideCreation) {
        this.hideCreation = hideCreation;
    }

    @Generated
    public void setPredicates(List<Predicate<T>> predicates) {
        this.predicates = predicates;
    }

    @Generated
    public void setComparator(Comparator<T> comparator) {
        this.comparator = comparator;
    }

    @Generated
    public void setManager(SObjectManager<T> manager) {
        this.manager = manager;
    }
}

