/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.emums;

import java.io.Serializable;
import lombok.Generated;

public enum VariableType implements Serializable
{
    STRING("STRING", "STR", "TEXT", "TXT"),
    NUMBER("NUMBER", "DOUBLE"),
    LIST("LIST", "ARRAY");

    private String[] names;

    private VariableType(String ... names) {
        this.names = names;
    }

    public boolean isValidOption(String entry) {
        for (VariableType var2 : VariableType.values()) {
            for (String name : var2.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return true;
            }
        }
        return false;
    }

    public VariableType getPrev() {
        VariableType opt = VariableType.values()[VariableType.values().length - 1];
        for (VariableType o : VariableType.values()) {
            if (this.equals(o)) {
                return opt;
            }
            opt = o;
        }
        return opt;
    }

    public VariableType getNext() {
        VariableType opt = VariableType.values()[0];
        boolean next = false;
        for (VariableType o : VariableType.values()) {
            if (next) {
                opt = o;
                break;
            }
            if (!this.equals(o)) continue;
            next = true;
        }
        return opt;
    }

    public VariableType getOption(String entry) {
        for (VariableType option : VariableType.values()) {
            for (String name : option.getNames()) {
                if (!name.equalsIgnoreCase(entry)) continue;
                return option;
            }
        }
        return null;
    }

    public boolean containsThisName(String entry) {
        for (String name : this.getNames()) {
            if (!name.equalsIgnoreCase(entry)) continue;
            return true;
        }
        return false;
    }

    @Generated
    public String[] getNames() {
        return this.names;
    }

    @Generated
    public void setNames(String[] names) {
        this.names = names;
    }
}

