/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.executableblocks.api.ExecutableBlocksAPI;
import com.ssomar.score.SCore;
import com.ssomar.score.api.executableblocks.config.placed.ExecutableBlockPlacedInterface;
import com.ssomar.score.usedapi.AllWorldManager;
import com.ssomar.score.usedapi.Dependency;
import com.ssomar.score.utils.ToolsListMaterial;
import com.ssomar.score.utils.backward_compatibility.BiomeUtils;
import com.ssomar.score.utils.placeholders.PlaceholdersInterface;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.block.data.Ageable;
import org.bukkit.block.data.BlockData;
import org.jetbrains.annotations.NotNull;

public class BlockPlaceholdersAbstract
extends PlaceholdersInterface
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String particle;
    private int blockX;
    private int blockY;
    private int blockZ;
    private UUID blockWorld;
    private String blockWorldName;
    private String EB_ID;
    private Biome biome;
    private String blockDimension;
    private Material fixType;
    private Map<String, String> placeholders;

    public BlockPlaceholdersAbstract(String particle) {
        this.particle = particle;
        this.placeholders = new HashMap<String, String>();
    }

    public void setBlockPlcHldr(@NotNull Block block) {
        this.setBlockPlcHldr(block, null);
    }

    public void setBlockPlcHldr(@NotNull Block block, Material fixType) {
        Location bLoc = block.getLocation();
        this.blockX = bLoc.getBlockX();
        this.blockY = bLoc.getBlockY();
        this.blockZ = bLoc.getBlockZ();
        this.blockWorld = bLoc.getWorld().getUID();
        this.biome = block.getBiome();
        switch (block.getWorld().getEnvironment()) {
            case NETHER: {
                this.blockDimension = "nether";
                break;
            }
            case CUSTOM: {
                this.blockDimension = "custom";
                break;
            }
            case NORMAL: {
                this.blockDimension = "normal";
                break;
            }
            case THE_END: {
                this.blockDimension = "end";
            }
        }
        if (fixType != null) {
            this.fixType = fixType;
        }
        if (Dependency.EXECUTABLE_BLOCKS.isEnabled()) {
            Optional executableBlockPlaced = ExecutableBlocksAPI.getExecutableBlocksPlacedManager().getExecutableBlockPlaced(block);
            this.EB_ID = executableBlockPlaced.isPresent() ? ((ExecutableBlockPlacedInterface)executableBlockPlaced.get()).getEB_ID() : "";
        }
        this.reloadBlockPlcHldr();
    }

    public void reloadBlockPlcHldr() {
        if (this.blockWorld != null) {
            CreatureSpawner spawner;
            Optional<World> worldOpt = AllWorldManager.getWorld(this.blockWorld);
            if (!worldOpt.isPresent()) {
                return;
            }
            World world = worldOpt.get();
            Location loc = new Location(world, (double)this.blockX, (double)this.blockY, (double)this.blockZ);
            Block block = loc.getBlock();
            this.blockWorldName = world.getName();
            Material type = block.getType();
            String blockType = type.toString();
            if (this.fixType != null) {
                blockType = this.fixType.toString();
            }
            this.placeholders.put("%" + this.particle + "%", blockType);
            this.placeholders.put("%" + this.particle + "_lower%", blockType.toLowerCase());
            this.placeholders.put("%" + this.particle + "_item_material%", ToolsListMaterial.getInstance().getRealMaterialOfBlock(Material.valueOf((String)blockType)).toString());
            this.placeholders.put("%" + this.particle + "_item_material_lower%", ToolsListMaterial.getInstance().getRealMaterialOfBlock(Material.valueOf((String)blockType)).toString().toLowerCase());
            this.placeholders.put("%" + this.particle + "_live%", type.toString());
            this.placeholders.put("%" + this.particle + "_live_lower%", type.toString().toLowerCase());
            this.placeholders.put("%" + this.particle + "_world%", this.blockWorldName);
            this.placeholders.put("%" + this.particle + "_world_lower%", this.blockWorldName.toLowerCase());
            this.placeholders.put("%" + this.particle + "_biome%", BiomeUtils.getBiomes().get(this.biome));
            this.placeholders.put("%" + this.particle + "_biome_lower%", BiomeUtils.getBiomes().get(this.biome).toLowerCase());
            this.placeholders.put("%" + this.particle + "_dimension%", this.blockDimension);
            this.placeholders.put("%" + this.particle + "_dimension_lower%", this.blockDimension.toLowerCase());
            this.placeholders.put("%" + this.particle + "_eb_id%", this.EB_ID);
            if (!SCore.is1v12Less()) {
                this.placeholders.put("%" + this.particle + "_data%", block.getBlockData().getAsString());
            }
            try {
                BlockData data = block.getState().getBlockData();
                if (data instanceof Ageable) {
                    this.placeholders.put("%" + this.particle + "_is_ageable%", "true");
                } else {
                    this.placeholders.put("%" + this.particle + "_is_ageable%", "false");
                }
            }
            catch (Error | Exception e) {
                this.placeholders.put("%" + this.particle + "_is_ageable%", "false");
            }
            boolean notValidSpawner = true;
            if (block.getState() instanceof CreatureSpawner && (spawner = (CreatureSpawner)block.getState()).getSpawnedType() != null) {
                notValidSpawner = false;
                this.placeholders.put("%" + this.particle + "_spawnertype%", spawner.getSpawnedType().toString());
            }
            if (notValidSpawner) {
                this.placeholders.put("%" + this.particle + "_spawnertype%", "null");
            }
        }
    }

    public String replacePlaceholder(String s) {
        String toReplace = s;
        if (this.blockWorld != null) {
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x%", this.blockX + "", false);
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y%", this.blockY + "", false);
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z%", this.blockZ + "", false);
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_x_int%", this.blockX + "", true);
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_y_int%", this.blockY + "", true);
            toReplace = BlockPlaceholdersAbstract.replaceCalculPlaceholder(toReplace, "%" + this.particle + "_z_int%", this.blockZ + "", true);
        }
        return toReplace;
    }

    @Generated
    public Map<String, String> getPlaceholders() {
        return this.placeholders;
    }
}

