/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.variables;

import com.ssomar.score.editor.NewInteractionClickedGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.editor.FeatureEditorManagerAbstract;
import com.ssomar.score.variables.Variable;
import com.ssomar.score.variables.VariableEditor;
import com.ssomar.score.variables.manager.VariablesManager;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class VariableEditorManager
extends FeatureEditorManagerAbstract<VariableEditor, Variable> {
    private static VariableEditorManager instance;

    @Override
    public VariableEditor buildEditor(Variable featureParentInterface) {
        return new VariableEditor(featureParentInterface.clone(featureParentInterface.getParent()));
    }

    public static VariableEditorManager getInstance() {
        if (instance == null) {
            instance = new VariableEditorManager();
        }
        return instance;
    }

    public void reloadEditor(NewInteractionClickedGUIManager<VariableEditor> i) {
        ((VariableEditor)i.gui).load();
        i.player.updateInventory();
    }

    @Override
    public void receiveMessage(NewInteractionClickedGUIManager<VariableEditor> i) {
        super.receiveMessage(i);
        this.reloadEditor(i);
    }

    @Override
    public void clicked(ItemStack item, NewInteractionClickedGUIManager<VariableEditor> interact, ClickType click) {
        super.clicked(item, interact, click);
        this.reloadEditor(interact);
    }

    @Override
    public boolean leftClicked(NewInteractionClickedGUIManager<VariableEditor> i) {
        boolean result = super.leftClicked(i);
        if (result) {
            this.reloadEditor(i);
        }
        return result;
    }

    @Override
    public boolean rightClicked(NewInteractionClickedGUIManager<VariableEditor> i) {
        boolean result = super.rightClicked(i);
        if (result) {
            this.reloadEditor(i);
        }
        return result;
    }

    @Override
    public void save(NewInteractionClickedGUIManager<VariableEditor> interact) {
        FeatureParentInterface<Variable, Variable> parent = ((VariableEditor)interact.gui).getParent();
        parent.save();
        parent.reload();
        while (parent instanceof FeatureInterface && ((FeatureAbstract)((Object)parent)).getParent() != parent) {
            parent = ((FeatureAbstract)((Object)parent)).getParent();
            parent.reload();
        }
        VariablesManager.getInstance().updateLoadedMySQL(((VariableEditor)interact.gui).getParent().getId(), VariablesManager.MODE.EXPORT);
    }
}

