/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.entity.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.entity.EntityCommand;
import com.ssomar.score.utils.backward_compatibility.AttributeUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;

public class Heal
extends EntityCommand {
    public Heal() {
        CommandSetting amount = new CommandSetting("amount", 0, Double.class, (Object)Double.MIN_VALUE);
        List<CommandSetting> settings = this.getSettings();
        settings.add(amount);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, Entity entity, SCommandToExec sCommandToExec) {
        double amount = (Double)sCommandToExec.getSettingValue("amount");
        boolean fullHeal = amount == Double.MIN_VALUE;
        Attribute att = null;
        att = SCore.is1v21v2Plus() ? Attribute.MAX_HEALTH : AttributeUtils.getAttribute("GENERIC_MAX_HEALTH");
        if (!fullHeal) {
            if (amount > 0.0 && !entity.isDead() && entity instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)entity;
                if (!SCore.is1v12Less()) {
                    e.setHealth(Math.min(e.getHealth() + amount, Objects.requireNonNull(e.getAttribute(att)).getValue()));
                } else {
                    e.setHealth(Math.min(e.getHealth() + amount, e.getMaxHealth()));
                }
            }
        } else if (!entity.isDead()) {
            LivingEntity e = (LivingEntity)entity;
            if (!SCore.is1v12Less()) {
                e.setHealth(e.getAttribute(att).getValue());
            } else {
                e.setHealth(e.getMaxHealth());
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("HEAL");
        return names;
    }

    @Override
    public String getTemplate() {
        return "HEAL amount:10";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

