/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.item.commands;

import com.ssomar.score.SCore;
import com.ssomar.score.commands.runnable.CommandSetting;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.item.ItemCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.bukkit.ChatColor;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class ModifyItemDurability
extends ItemCommand {
    public ModifyItemDurability() {
        CommandSetting modification = new CommandSetting("modification", -1, Integer.class, (Object)50);
        CommandSetting supportUnbreaking = new CommandSetting("supportUnbreaking", -1, Boolean.class, (Object)false);
        List<CommandSetting> settings = this.getSettings();
        settings.add(modification);
        settings.add(supportUnbreaking);
        this.setNewSettingsMode(true);
    }

    @Override
    public void run(Player p, ItemStack itemStack, SCommandToExec sCommandToExec) {
        int modification = (Integer)sCommandToExec.getSettingValue("modification");
        boolean supportUnbreaking = (Boolean)sCommandToExec.getSettingValue("supportUnbreaking");
        ItemStack item = itemStack;
        if (item == null) {
            return;
        }
        if (!item.hasItemMeta()) {
            item.setItemMeta(new ItemStack(item.getType()).getItemMeta());
        }
        if (item.getItemMeta() instanceof Damageable) {
            Enchantment unbreaking;
            Damageable meta = (Damageable)item.getItemMeta();
            Map enchants = item.getEnchantments();
            int unbreakingLevel = 0;
            Enchantment enchantment = unbreaking = SCore.is1v20v5Plus() ? Enchantment.UNBREAKING : Enchantment.getByName((String)"DURABILITY");
            if (supportUnbreaking && enchants.containsKey(unbreaking)) {
                unbreakingLevel = (Integer)enchants.get(unbreaking);
            }
            int maxDura = item.getType().getMaxDurability();
            if (SCore.is1v21Plus() && meta.hasMaxDamage()) {
                maxDura = meta.getMaxDamage();
            }
            if (modification < 0) {
                for (int i = modification; i < 0; ++i) {
                    int random = (int)(Math.random() * 100.0);
                    if (random <= 100 / (unbreakingLevel + 1)) continue;
                    ++modification;
                }
                meta.setDamage(meta.getDamage() - modification);
                if (meta.getDamage() >= maxDura) {
                    item.setAmount(item.getAmount() - 1);
                    return;
                }
                item.setItemMeta((ItemMeta)meta);
            } else {
                int newDamage = meta.getDamage() - modification;
                if (newDamage < 0) {
                    newDamage = 0;
                }
                meta.setDamage(newDamage);
                item.setItemMeta((ItemMeta)meta);
            }
        }
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("MODIFY_ITEM_DURABILITY");
        names.add("MODIFY_DURABILITY");
        return names;
    }

    @Override
    public String getTemplate() {
        return "MODIFY_ITEM_DURABILITY modification:50 supportUnbreaking:false";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

