/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.runnable.mixed_player_entity.commands;

import com.ssomar.score.commands.runnable.ArgumentChecker;
import com.ssomar.score.commands.runnable.SCommandToExec;
import com.ssomar.score.commands.runnable.mixed_player_entity.MixedCommand;
import com.ssomar.score.usedapi.AllWorldManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Teleport
extends MixedCommand {
    @Override
    public void run(Player p, Entity receiver, SCommandToExec sCommandToExec) {
        List<String> args = sCommandToExec.getOtherArgs();
        World world = AllWorldManager.getWorld(args.get(0)).get();
        double x = Double.parseDouble(args.get(1));
        double y = Double.parseDouble(args.get(2));
        double z = Double.parseDouble(args.get(3));
        float pitch = receiver.getLocation().getPitch();
        float yaw = receiver.getLocation().getYaw();
        Vector velocity = receiver.getVelocity();
        boolean keepVelocity = false;
        if (args.size() >= 5) {
            pitch = Float.parseFloat(args.get(4));
        }
        if (args.size() >= 6) {
            yaw = Float.parseFloat(args.get(5));
        }
        if (args.size() >= 7) {
            keepVelocity = Boolean.parseBoolean(args.get(6));
        }
        Location loc = new Location(world, x, y, z);
        loc.setPitch(pitch);
        loc.setYaw(yaw);
        receiver.teleport(loc);
        if (keepVelocity) {
            receiver.setVelocity(velocity);
        }
    }

    @Override
    public Optional<String> verify(List<String> args, boolean isFinalVerification) {
        return Teleport.staticVerif(args, isFinalVerification, this.getTemplate());
    }

    public static Optional<String> staticVerif(List<String> args, boolean isFinalVerification, String template) {
        String value;
        ArgumentChecker ac3;
        if (args.size() < 4) {
            return Optional.of("&cThere is &6not enough args &cfor the command: &e" + template);
        }
        ArgumentChecker ac = Teleport.checkWorld(args.get(0), isFinalVerification, template);
        if (!ac.isValid()) {
            return Optional.of(ac.getError());
        }
        for (int i = 1; i < 4; ++i) {
            ArgumentChecker ac2 = Teleport.checkDouble(args.get(i), isFinalVerification, template);
            if (ac2.isValid()) continue;
            return Optional.of(ac2.getError());
        }
        if (args.size() >= 5 && !(ac3 = Teleport.checkDouble(value = args.get(4), isFinalVerification, template)).isValid()) {
            return Optional.of(ac3.getError());
        }
        if (args.size() >= 6 && !(ac3 = Teleport.checkDouble(value = args.get(5), isFinalVerification, template)).isValid()) {
            return Optional.of(ac3.getError());
        }
        if (args.size() >= 7 && !(ac3 = Teleport.checkBoolean(value = args.get(6), isFinalVerification, template)).isValid()) {
            return Optional.of(ac3.getError());
        }
        return Optional.empty();
    }

    @Override
    public List<String> getNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add("TELEPORT");
        return names;
    }

    @Override
    public String getTemplate() {
        return "TELEPORT {world} {x} {y} {z} [pitch] [yaw] [keepVelocity]";
    }

    @Override
    public ChatColor getColor() {
        return null;
    }

    @Override
    public ChatColor getExtraColor() {
        return null;
    }
}

