/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.commands.score;

import com.ssomar.score.commands.score.CustomCommandWithManagerAbstract;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectBuildable;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class DropCommand<X extends SPlugin, Y extends SObjectManager<Z>, Z extends SObject>
extends CustomCommandWithManagerAbstract<X, Y, Z> {
    public DropCommand(X sPlugin, Y sObjectManager) {
        super(sPlugin, sObjectManager);
    }

    @Override
    public void run(CommandSender sender, String command, String[] args, String typedCommand) {
        switch (command) {
            case "drop": {
                if (args.length == 0) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &c" + ((SObjectManager)this.getSObjectManager()).getObjectName() + " &6" + args[0] + " &cnot found");
                    return;
                }
                ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
                Map<String, Object> settings = StringSetting.extractSettingsAndRebuildCorrectly(arguments, 0, new ArrayList<String>());
                Optional objectOpt = this.checkSObject(sender, (String)arguments.get(0));
                if (!objectOpt.isPresent()) {
                    return;
                }
                SObjectBuildable droppable = (SObjectBuildable)objectOpt.get();
                AtomicInteger qty = new AtomicInteger();
                if (arguments.size() == 1) {
                    qty.set(1);
                } else {
                    Optional<Integer> amount = this.checkAmount(sender, (String)arguments.get(1));
                    if (!amount.isPresent()) {
                        this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &cInvalid amount : &6" + (String)arguments.get(1));
                        return;
                    }
                    qty.set(amount.get());
                }
                if (sender instanceof Player) {
                    Player p = (Player)sender;
                    if (arguments.size() <= 2) {
                        ((SObjectBuildable)((Object)((SObject)objectOpt.get()))).dropItem(p.getLocation(), qty.get(), Optional.empty(), settings);
                        return;
                    }
                }
                if (arguments.size() < 6) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &cUsage: &6/" + this.getSPlugin().getShortName().toLowerCase() + " drop <" + ((SObjectManager)this.getSObjectManager()).getObjectName() + "> <quantity> <world> <x> <y> <z>");
                    return;
                }
                Optional<Optional<World>> worldOptional = this.checkWorld(sender, (String)arguments.get(2));
                if (!worldOptional.isPresent() || !worldOptional.get().isPresent()) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &c WORLD &6" + (String)arguments.get(2) + " &cis invalid.");
                    return;
                }
                World world = worldOptional.get().get();
                Optional<Double> xOpt = this.checkDouble(sender, (String)arguments.get(3));
                if (!xOpt.isPresent()) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &c X &6" + (String)arguments.get(3) + " &cis invalid.");
                    return;
                }
                Optional<Double> yOpt = this.checkDouble(sender, (String)arguments.get(4));
                if (!yOpt.isPresent()) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &c Y &6" + (String)arguments.get(4) + " &cis invalid.");
                    return;
                }
                Optional<Double> zOpt = this.checkDouble(sender, (String)arguments.get(5));
                if (!zOpt.isPresent()) {
                    this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameWithBrackets() + " &c Z &6" + (String)arguments.get(5) + " &cis invalid.");
                    return;
                }
                ((SObjectBuildable)((Object)((SObject)objectOpt.get()))).dropItem(new Location(world, xOpt.get().doubleValue(), yOpt.get().doubleValue(), zOpt.get().doubleValue()), qty.get(), Optional.empty(), settings);
                this.getSm().sendMessage(sender, "&c" + this.getSPlugin().getNameDesign() + " &7Successfully run &e/" + this.getSPlugin().getShortName().toLowerCase() + " drop " + (String)arguments.get(0) + " " + qty + " " + world.getName() + " " + xOpt.get() + " " + yOpt.get() + " " + zOpt.get());
            }
        }
    }

    @Override
    public List<String> getCommands() {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add("drop");
        return commands;
    }

    @Override
    public List<String> getArguments(String command, String[] args) {
        ArrayList<String> arguments = new ArrayList<String>();
        switch (args[0]) {
            case "drop": {
                if (args.length == 2) {
                    return ((SObjectManager)this.getSObjectManager()).getLoadedObjectsWith(args[1]);
                }
                if (args.length == 3) {
                    arguments.addAll(DropCommand.getArgumentsQuantity());
                    return arguments;
                }
                if (args.length == 4) {
                    for (World world : Bukkit.getServer().getWorlds()) {
                        arguments.add(world.getName());
                    }
                    return arguments;
                }
                if (args.length == 5) {
                    arguments.add("X");
                    return arguments;
                }
                if (args.length == 6) {
                    arguments.add("Y");
                    return arguments;
                }
                if (args.length != 7) break;
                arguments.add("Z");
                return arguments;
            }
        }
        return new ArrayList<String>();
    }
}

