/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.editor.Suggestion;
import com.ssomar.score.features.FeatureForItem;
import com.ssomar.score.features.FeatureForItemArgs;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.features.types.list.ListUncoloredStringFeature;
import com.ssomar.score.utils.emums.ResetSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.CrossbowMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemChargedProjectilesFeature
extends ListUncoloredStringFeature
implements FeatureForItem {
    private static final boolean DEBUG = true;

    public ItemChargedProjectilesFeature(FeatureParentInterface parent, List<String> defaultValue, FeatureSettingsInterface featureSettings, Optional<List<Suggestion>> suggestions) {
        super(parent, defaultValue, featureSettings, suggestions);
    }

    @Override
    public boolean isAvailable() {
        return SCore.is1v20v5Plus();
    }

    @Override
    public boolean isApplicable(FeatureForItemArgs args) {
        return args.getMeta() instanceof CrossbowMeta;
    }

    @Override
    public void applyOnItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        if (!this.isAvailable() || !this.isApplicable(args)) {
            return;
        }
        CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String value : this.getValues()) {
            ItemStack item = Bukkit.getServer().getItemFactory().createItemStack(value);
            SsomarDev.testMsg("ItemContainerFeature applyOnItemMeta: the item " + item, true);
            items.add(item);
        }
        crossbowMeta.setChargedProjectiles(items);
    }

    @Override
    public void loadFromItemMeta(FeatureForItemArgs args) {
        ItemMeta meta = args.getMeta();
        ArrayList<String> values = new ArrayList<String>();
        SsomarDev.testMsg("ItemChargedProjectileFeature loadFromItemMeta: " + meta, true);
        if (meta instanceof CrossbowMeta) {
            CrossbowMeta crossbowMeta = (CrossbowMeta)meta;
            if (!crossbowMeta.hasChargedProjectiles()) {
                return;
            }
            for (ItemStack item : crossbowMeta.getChargedProjectiles()) {
                String value = item.hasItemMeta() ? "minecraft:" + item.getType().toString().toLowerCase() + item.getItemMeta().getAsString() : "minecraft:" + item.getType().toString().toLowerCase();
                SsomarDev.testMsg("ItemChargedProjectileFeature loadFromItemMeta: the item meta " + value, true);
                values.add(value);
            }
        } else {
            SsomarDev.testMsg("ItemChargedProjectileFeature loadFromItemMeta: the meta is not a CrossbowMeta", true);
        }
        this.setValues(values);
    }

    @Override
    public ResetSetting getResetSetting() {
        return ResetSetting.CHARGED_PROJECTILES;
    }

    @Override
    public ItemChargedProjectilesFeature clone(FeatureParentInterface newParent) {
        ItemChargedProjectilesFeature clone = new ItemChargedProjectilesFeature(newParent, this.getDefaultValue(), this.getFeatureSettings(), Optional.empty());
        clone.setValues(this.getValues());
        return clone;
    }
}

