/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.conditions.player.condition;

import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionFeature;
import com.ssomar.score.features.custom.conditions.player.PlayerConditionRequest;
import com.ssomar.score.features.types.NumberConditionFeature;
import com.ssomar.score.utils.strings.StringCalculation;
import java.util.Optional;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class IfPlayerBedSpawnLocationY
extends PlayerConditionFeature<NumberConditionFeature, IfPlayerBedSpawnLocationY> {
    public IfPlayerBedSpawnLocationY(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.ifPlayerBedSpawnLocationY);
    }

    @Override
    public boolean verifCondition(PlayerConditionRequest request) {
        if (this.hasCondition()) {
            Player player = request.getPlayer();
            Location bedSpawn = player.getBedSpawnLocation();
            if (bedSpawn == null) {
                this.runInvalidCondition(request);
                return false;
            }
            double y = bedSpawn.getY();
            if (!StringCalculation.calculation(((NumberConditionFeature)this.getCondition()).getValue(Optional.of(player), request.getSp()).get(), y)) {
                this.runInvalidCondition(request);
                return false;
            }
        }
        return true;
    }

    @Override
    public IfPlayerBedSpawnLocationY getValue() {
        return this;
    }

    @Override
    public void subReset() {
        this.setCondition(new NumberConditionFeature(this.getParent(), FeatureSettingsSCore.ifPlayerBedSpawnLocationY));
    }

    @Override
    public boolean hasCondition() {
        return ((Optional)((NumberConditionFeature)this.getCondition()).getValue()).isPresent();
    }

    @Override
    public IfPlayerBedSpawnLocationY getNewInstance(FeatureParentInterface parent) {
        return new IfPlayerBedSpawnLocationY(parent);
    }
}

