/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.customlists;

import com.ssomar.score.SCore;
import com.ssomar.score.utils.logging.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class CustomListsManager {
    private static CustomListsManager instance;
    private Map<String, List<String>> entityLists = new HashMap<String, List<String>>();
    private Map<String, List<String>> blockLists = new HashMap<String, List<String>>();

    private CustomListsManager() {
    }

    public static CustomListsManager getInstance() {
        if (instance == null) {
            instance = new CustomListsManager();
        }
        return instance;
    }

    public void load() {
        ConfigurationSection blockListsSection;
        this.entityLists.clear();
        this.blockLists.clear();
        File configFile = new File(SCore.plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            Utils.sendConsoleMsg("&e[SCore] CustomListsManager: config.yml not found, skipping custom lists loading");
            return;
        }
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        ConfigurationSection entityListsSection = config.getConfigurationSection("entityLists");
        if (entityListsSection != null) {
            for (String listName : entityListsSection.getKeys(false)) {
                List entities = entityListsSection.getStringList(listName);
                if (entities.isEmpty()) continue;
                this.entityLists.put(listName.toUpperCase(), entities);
                Utils.sendConsoleMsg("&a[SCore] CustomListsManager: Loaded entity list '" + listName + "' with " + entities.size() + " entries");
            }
        }
        if ((blockListsSection = config.getConfigurationSection("blockLists")) != null) {
            for (String listName : blockListsSection.getKeys(false)) {
                List blocks = blockListsSection.getStringList(listName);
                if (blocks.isEmpty()) continue;
                this.blockLists.put(listName.toUpperCase(), blocks);
                Utils.sendConsoleMsg("&a[SCore] CustomListsManager: Loaded block list '" + listName + "' with " + blocks.size() + " entries");
            }
        }
        Utils.sendConsoleMsg("&a[SCore] CustomListsManager: Loaded " + this.entityLists.size() + " entity lists and " + this.blockLists.size() + " block lists");
    }

    public Optional<List<String>> getEntityList(String listName) {
        List<String> list = this.entityLists.get(listName.toUpperCase());
        return list != null ? Optional.of(new ArrayList<String>(list)) : Optional.empty();
    }

    public Optional<List<String>> getBlockList(String listName) {
        List<String> list = this.blockLists.get(listName.toUpperCase());
        return list != null ? Optional.of(new ArrayList<String>(list)) : Optional.empty();
    }

    public boolean hasEntityList(String listName) {
        return this.entityLists.containsKey(listName.toUpperCase());
    }

    public boolean hasBlockList(String listName) {
        return this.blockLists.containsKey(listName.toUpperCase());
    }

    public void reload() {
        this.load();
    }

    @Generated
    public Map<String, List<String>> getEntityLists() {
        return this.entityLists;
    }

    @Generated
    public Map<String, List<String>> getBlockLists() {
        return this.blockLists;
    }
}

