/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.ifhas.items.attribute;

import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.detailedslots.DetailedSlots;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.features.types.MaterialFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class HasItemFeature
extends FeatureWithHisOwnEditor<HasItemFeature, HasItemFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager> {
    private MaterialFeature material;
    private IntegerFeature amount;
    private DetailedSlots detailedSlots;
    private String id;

    public HasItemFeature(FeatureParentInterface parent, String id) {
        super(parent, FeatureSettingsSCore.hasItem);
        this.id = id;
        this.reset();
    }

    @Override
    public void reset() {
        this.material = new MaterialFeature(this, Optional.of(Material.STONE), FeatureSettingsSCore.material);
        this.amount = new IntegerFeature(this, Optional.of(1), FeatureSettingsSCore.amount);
        this.detailedSlots = new DetailedSlots(this);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.id)) {
            ConfigurationSection enchantmentConfig = config.getConfigurationSection(this.id);
            errors.addAll(this.material.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.amount.load(plugin, enchantmentConfig, isPremiumLoading));
            errors.addAll(this.detailedSlots.load(plugin, enchantmentConfig, isPremiumLoading));
        } else {
            errors.add("&cERROR, Couldn't load the Item feature because there is not section with the good ID: " + this.id + " &7&o" + this.getParent().getParentInfo());
        }
        return errors;
    }

    @Override
    public boolean isTheFeatureClickedParentEditor(String featureClicked) {
        return featureClicked.contains(this.getEditorName()) && featureClicked.contains("(" + this.id + ")");
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.id, null);
        ConfigurationSection attributeConfig = config.createSection(this.id);
        this.material.save(attributeConfig);
        this.amount.save(attributeConfig);
        this.detailedSlots.save(attributeConfig);
    }

    @Override
    public HasItemFeature getValue() {
        return this;
    }

    @Override
    public HasItemFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 4];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 4] = ((Optional)this.material.getValue()).isPresent() ? "&7Item: &e" + ((Optional)this.material.getValue()).get() : "&7Item: &cINVALID EI";
        finalDescription[finalDescription.length - 3] = "&7Amount: &e" + ((Optional)this.amount.getValue()).get();
        finalDescription[finalDescription.length - 2] = "&7Slots count: &e" + this.detailedSlots.getSlots().size();
        finalDescription[finalDescription.length - 1] = GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName() + " - (" + this.id + ")", false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public HasItemFeature clone(FeatureParentInterface newParent) {
        HasItemFeature eF = new HasItemFeature(newParent, this.id);
        eF.setMaterial(this.material.clone(eF));
        eF.setAmount(this.amount.clone(eF));
        eF.setDetailedSlots(this.detailedSlots.clone(eF));
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(Arrays.asList(this.material, this.amount, this.detailedSlots));
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection parentSection = this.getParent().getConfigurationSection();
        if (parentSection.isConfigurationSection(this.getId())) {
            return parentSection.getConfigurationSection(this.getId());
        }
        return parentSection.createSection(this.getId());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            HasItemFeature aFOF;
            if (!(feature instanceof HasItemFeature) || !(aFOF = (HasItemFeature)feature).getId().equals(this.id)) continue;
            aFOF.setMaterial(this.material);
            aFOF.setAmount(this.amount);
            aFOF.setDetailedSlots(this.detailedSlots);
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Generated
    public MaterialFeature getMaterial() {
        return this.material;
    }

    @Generated
    public IntegerFeature getAmount() {
        return this.amount;
    }

    @Generated
    public DetailedSlots getDetailedSlots() {
        return this.detailedSlots;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public void setMaterial(MaterialFeature material) {
        this.material = material;
    }

    @Generated
    public void setAmount(IntegerFeature amount) {
        this.amount = amount;
    }

    @Generated
    public void setDetailedSlots(DetailedSlots detailedSlots) {
        this.detailedSlots = detailedSlots;
    }

    @Generated
    public void setId(String id) {
        this.id = id;
    }
}

