/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.potionsettings;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.custom.potioneffects.group.PotionEffectGroupFeature;
import com.ssomar.score.features.custom.potioneffects.potioneffect.PotionEffectFeature;
import com.ssomar.score.features.editor.GenericFeatureParentEditor;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColorIntegerFeature;
import com.ssomar.score.features.types.PotionTypeFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.projectiles.features.SProjectileFeatureInterface;
import com.ssomar.score.splugin.SPlugin;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.jetbrains.annotations.NotNull;

public class PotionSettingsFeature
extends FeatureWithHisOwnEditor<PotionSettingsFeature, PotionSettingsFeature, GenericFeatureParentEditor, GenericFeatureParentEditorManager>
implements SProjectileFeatureInterface {
    private ColorIntegerFeature color;
    private PotionTypeFeature potiontype;
    private BooleanFeature potionExtended;
    private BooleanFeature potionUpgraded;
    private PotionEffectGroupFeature potionEffects;

    public PotionSettingsFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.potionFeatures);
        this.reset();
    }

    @Override
    public void reset() {
        this.color = new ColorIntegerFeature(this, Optional.empty(), FeatureSettingsSCore.potionColor);
        this.potiontype = new PotionTypeFeature(this, Optional.ofNullable(PotionType.WATER), FeatureSettingsSCore.potionType);
        this.potionExtended = new BooleanFeature(this, false, FeatureSettingsSCore.potionExtended);
        this.potionUpgraded = new BooleanFeature(this, false, FeatureSettingsSCore.potionUpgraded);
        this.potionEffects = new PotionEffectGroupFeature((FeatureParentInterface)this, false);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection potionSettings = config.getConfigurationSection(this.getName());
            errors.addAll(this.color.load(plugin, potionSettings, isPremiumLoading));
            errors.addAll(this.potiontype.load(plugin, potionSettings, isPremiumLoading));
            if (!SCore.is1v20v5Plus()) {
                errors.addAll(this.potionExtended.load(plugin, potionSettings, isPremiumLoading));
                errors.addAll(this.potionUpgraded.load(plugin, potionSettings, isPremiumLoading));
            }
            errors.addAll(this.potionEffects.load(plugin, potionSettings, isPremiumLoading));
        }
        return errors;
    }

    public List<String> load(SPlugin plugin, ItemStack item, boolean isPremiumLoading) {
        ItemMeta meta;
        if (item.hasItemMeta() && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta pMeta = (PotionMeta)meta;
            if (!SCore.is1v11Less() && pMeta.getColor() != null) {
                this.color.setValue(Optional.of(pMeta.getColor().asRGB()));
            }
            int i = 0;
            for (PotionEffect pE : pMeta.getCustomEffects()) {
                PotionEffectFeature pEF = new PotionEffectFeature((FeatureParentInterface)this.potionEffects, "pEffect" + i);
                pEF.getType().setValue(Optional.of(pE.getType()));
                pEF.getAmplifier().setValue(Optional.of(pE.getAmplifier()));
                pEF.getDuration().setValue(Optional.of(pE.getDuration()));
                pEF.getAmbient().setValue(pE.isAmbient());
                pEF.getParticles().setValue(pE.hasParticles());
                pEF.getIcon().setValue(pE.hasIcon());
                this.potionEffects.getEffects().put("pEffect" + i, pEF);
                ++i;
            }
        }
        return new ArrayList<String>();
    }

    public ItemStack clear(@NotNull ItemStack item) {
        ItemMeta meta;
        if (item.hasItemMeta() && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta pMeta = (PotionMeta)meta;
            pMeta.clearCustomEffects();
            item.setItemMeta((ItemMeta)pMeta);
        }
        return item;
    }

    public ItemStack addTo(@NotNull ItemStack item) {
        ItemMeta meta;
        if (item.hasItemMeta() && (meta = item.getItemMeta()) instanceof PotionMeta) {
            PotionMeta pMeta = (PotionMeta)meta;
            if (!SCore.is1v11Less()) {
                if (((Optional)this.color.getValue()).isPresent()) {
                    pMeta.setColor(Color.fromRGB((int)((Integer)((Optional)this.color.getValue()).get())));
                }
                if (((Optional)this.potiontype.getValue()).isPresent()) {
                    if (SCore.is1v20v5Plus()) {
                        pMeta.setBasePotionType((PotionType)((Optional)this.potiontype.getValue()).get());
                    } else {
                        try {
                            PotionData data = new PotionData((PotionType)((Optional)this.potiontype.getValue()).get(), this.potionExtended.getValue() != false && ((PotionType)((Optional)this.potiontype.getValue()).get()).isExtendable(), this.potionUpgraded.getValue() != false && ((PotionType)((Optional)this.potiontype.getValue()).get()).isUpgradeable());
                            PotionMeta.class.getMethod("setBasePotionData", PotionData.class).invoke((Object)pMeta, data);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
            for (PotionEffectFeature pE : this.potionEffects.getEffects().values()) {
                pMeta.addCustomEffect(pE.getPotionEffect(), true);
            }
            item.setItemMeta((ItemMeta)pMeta);
        }
        return item;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection potionSettings = config.createSection(this.getName());
        this.color.save(potionSettings);
        this.potiontype.save(potionSettings);
        if (!SCore.is1v20v5Plus()) {
            this.potionExtended.save(potionSettings);
            this.potionUpgraded.save(potionSettings);
        }
        this.potionEffects.save(potionSettings);
    }

    @Override
    public PotionSettingsFeature getValue() {
        return this;
    }

    @Override
    public PotionSettingsFeature initItemParentEditor(GUI gui, int slot) {
        int settingsNumber = 6;
        if (SCore.is1v20v5Plus()) {
            settingsNumber = 4;
        }
        String[] finalDescription = new String[this.getEditorDescription().length + settingsNumber];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - settingsNumber] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - --settingsNumber] = SCore.is1v11Less() ? "&7Potion color : &c&lNot for 1.11 or lower" : (((Optional)this.color.getValue()).isPresent() ? "&7Potion color : &e" + ((Optional)this.color.getValue()).get() : "&7Potion color : &cNO VALUE");
        finalDescription[finalDescription.length - --settingsNumber] = SCore.is1v11Less() ? "&7Potion type : &c&lNot for 1.11 or lower" : "&7Potion type : &e" + ((Optional)this.potiontype.getValue()).get();
        --settingsNumber;
        if (!SCore.is1v20v5Plus()) {
            finalDescription[finalDescription.length - settingsNumber] = SCore.is1v11Less() ? "&7Potion extended : &c&lNot for 1.11 or lower" : (this.potionExtended.getValue() != false ? "&7Potion extended: &a&l\u2714" : "&7Potion extended: &c&l\u2718");
            finalDescription[finalDescription.length - --settingsNumber] = SCore.is1v11Less() ? "&7Potion upgraded : &c&lNot for 1.11 or lower" : (this.potionUpgraded.getValue() != false ? "&7Potion upgraded: &a&l\u2714" : "&7Potion upgraded: &c&l\u2718");
            --settingsNumber;
        }
        finalDescription[finalDescription.length - settingsNumber] = "&7Potion effects: &e" + this.potionEffects.getValue().getEffects().size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public PotionSettingsFeature clone(FeatureParentInterface newParent) {
        PotionSettingsFeature dropFeatures = new PotionSettingsFeature(newParent);
        dropFeatures.setColor(this.getColor().clone(dropFeatures));
        dropFeatures.setPotiontype(this.getPotiontype().clone(dropFeatures));
        dropFeatures.setPotionExtended(this.getPotionExtended().clone(dropFeatures));
        dropFeatures.setPotionUpgraded(this.getPotionUpgraded().clone(dropFeatures));
        dropFeatures.setPotionEffects(this.getPotionEffects().clone(dropFeatures));
        return dropFeatures;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        if (!SCore.is1v11Less()) {
            features.add(this.color);
            features.add(this.potiontype);
            if (!SCore.is1v20v5Plus()) {
                features.add(this.potionExtended);
                features.add(this.potionUpgraded);
            }
        }
        features.add(this.potionEffects);
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof PotionSettingsFeature)) continue;
            PotionSettingsFeature hiders = (PotionSettingsFeature)feature;
            hiders.setColor(this.getColor());
            hiders.setPotiontype(this.getPotiontype());
            hiders.setPotionExtended(this.getPotionExtended());
            hiders.setPotionUpgraded(this.getPotionUpgraded());
            hiders.setPotionEffects(this.getPotionEffects());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        GenericFeatureParentEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void transformTheProjectile(Entity e, Player launcher, Material materialLaunched) {
        if (e instanceof ThrownPotion) {
            ThrownPotion lp = (ThrownPotion)e;
            try {
                ItemStack item = lp.getItem();
                item = this.addTo(item);
                lp.setItem(item);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
    }

    @Generated
    public ColorIntegerFeature getColor() {
        return this.color;
    }

    @Generated
    public PotionTypeFeature getPotiontype() {
        return this.potiontype;
    }

    @Generated
    public BooleanFeature getPotionExtended() {
        return this.potionExtended;
    }

    @Generated
    public BooleanFeature getPotionUpgraded() {
        return this.potionUpgraded;
    }

    @Generated
    public PotionEffectGroupFeature getPotionEffects() {
        return this.potionEffects;
    }

    @Generated
    public void setColor(ColorIntegerFeature color) {
        this.color = color;
    }

    @Generated
    public void setPotiontype(PotionTypeFeature potiontype) {
        this.potiontype = potiontype;
    }

    @Generated
    public void setPotionExtended(BooleanFeature potionExtended) {
        this.potionExtended = potionExtended;
    }

    @Generated
    public void setPotionUpgraded(BooleanFeature potionUpgraded) {
        this.potionUpgraded = potionUpgraded;
    }

    @Generated
    public void setPotionEffects(PotionEffectGroupFeature potionEffects) {
        this.potionEffects = potionEffects;
    }
}

