/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.required.magic.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.required.RequiredPlayerInterface;
import com.ssomar.score.features.custom.required.magic.group.RequiredMagicGroupFeatureEditor;
import com.ssomar.score.features.custom.required.magic.group.RequiredMagicGroupFeatureEditorManager;
import com.ssomar.score.features.custom.required.magic.magic.RequiredMagicFeature;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.ColoredStringFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.messages.SendMessage;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.jetbrains.annotations.NotNull;

public class RequiredMagicGroupFeature
extends FeatureWithHisOwnEditor<RequiredMagicGroupFeature, RequiredMagicGroupFeature, RequiredMagicGroupFeatureEditor, RequiredMagicGroupFeatureEditorManager>
implements FeaturesGroup<RequiredMagicFeature>,
RequiredPlayerInterface {
    private Map<String, RequiredMagicFeature> requiredMagics;
    private ColoredStringFeature errorMessage;
    private BooleanFeature cancelEventIfError;

    public RequiredMagicGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.requiredMagics);
        this.reset();
    }

    @Override
    public void reset() {
        this.requiredMagics = new HashMap<String, RequiredMagicFeature>();
        this.errorMessage = new ColoredStringFeature(this, Optional.of("&4&l>> &cError you don't have the required magics"), FeatureSettingsSCore.errorMessage);
        this.cancelEventIfError = new BooleanFeature(this, false, FeatureSettingsSCore.cancelEventIfError);
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection requiredItemGroupSection = config.getConfigurationSection(this.getName());
            for (String attributeID : requiredItemGroupSection.getKeys(false)) {
                if (attributeID.equals(this.errorMessage.getName()) || attributeID.equals(this.cancelEventIfError.getName())) continue;
                if (!isPremiumLoading && this.isRequirePremium()) {
                    error.add("&cERROR, Couldn't load the " + attributeID + " value of " + this.getEditorName() + " from config &6>> Because it's a premium feature !");
                    break;
                }
                RequiredMagicFeature attribute = new RequiredMagicFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, requiredItemGroupSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.requiredMagics.put(attributeID, attribute);
            }
            this.errorMessage.load(plugin, requiredItemGroupSection, isPremiumLoading);
            this.cancelEventIfError.load(plugin, requiredItemGroupSection, isPremiumLoading);
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.requiredMagics.keySet()) {
            this.requiredMagics.get(enchantmentID).save(attributesSection);
        }
        this.errorMessage.save(attributesSection);
        this.cancelEventIfError.save(attributesSection);
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public RequiredMagicGroupFeature getValue() {
        return this;
    }

    @Override
    public RequiredMagicGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oRequiredMagic(s) added: &e" + this.requiredMagics.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public RequiredMagicGroupFeature clone(FeatureParentInterface newParent) {
        RequiredMagicGroupFeature eF = new RequiredMagicGroupFeature(newParent);
        HashMap<String, RequiredMagicFeature> newRequiredExecutableItems = new HashMap<String, RequiredMagicFeature>();
        for (String enchantmentID : this.requiredMagics.keySet()) {
            newRequiredExecutableItems.put(enchantmentID, this.requiredMagics.get(enchantmentID).clone(eF));
        }
        eF.setRequiredMagics(newRequiredExecutableItems);
        eF.setErrorMessage(this.getErrorMessage().clone(eF));
        eF.setCancelEventIfError(this.getCancelEventIfError().clone(eF));
        eF.setPremium(this.isPremium());
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>(this.requiredMagics.values());
        features.add((RequiredMagicFeature)((Object)this.errorMessage));
        features.add((RequiredMagicFeature)((Object)this.cancelEventIfError));
        return features;
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo() + ".(" + this.getName() + ")";
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof RequiredMagicGroupFeature)) continue;
            RequiredMagicGroupFeature eF = (RequiredMagicGroupFeature)feature;
            eF.setRequiredMagics(this.getRequiredMagics());
            eF.setErrorMessage(this.getErrorMessage());
            eF.setCancelEventIfError(this.getCancelEventIfError());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return;
        }
        RequiredMagicGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "requiredMagic_";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.requiredMagics.containsKey(id)) continue;
            RequiredMagicFeature eF = new RequiredMagicFeature((FeatureParentInterface)this, id);
            this.requiredMagics.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, RequiredMagicFeature feature) {
        this.requiredMagics.remove(feature.getId());
    }

    @Override
    public RequiredMagicFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (RequiredMagicFeature rEI : this.requiredMagics.values()) {
            if (!rEI.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return rEI;
        }
        return null;
    }

    @Override
    public boolean verify(Player player, Event event, StringPlaceholder sp) {
        for (RequiredMagicFeature eF : this.requiredMagics.values()) {
            if (eF.verify(player, event, sp)) continue;
            if (((Optional)this.errorMessage.getValue()).isPresent()) {
                String message = (String)((Optional)this.errorMessage.getValue()).get();
                message = sp.replacePlaceholder(message);
                SendMessage.sendMessageNoPlch(player, message);
            }
            if (this.cancelEventIfError.getValue().booleanValue() && event instanceof Cancellable) {
                ((Cancellable)event).setCancelled(true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void take(Player player, StringPlaceholder sp) {
        for (RequiredMagicFeature eF : this.requiredMagics.values()) {
            eF.take(player, sp);
        }
    }

    @Generated
    public Map<String, RequiredMagicFeature> getRequiredMagics() {
        return this.requiredMagics;
    }

    @Generated
    public ColoredStringFeature getErrorMessage() {
        return this.errorMessage;
    }

    @Generated
    public BooleanFeature getCancelEventIfError() {
        return this.cancelEventIfError;
    }

    @Generated
    public void setRequiredMagics(Map<String, RequiredMagicFeature> requiredMagics) {
        this.requiredMagics = requiredMagics;
    }

    @Generated
    public void setErrorMessage(ColoredStringFeature errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Generated
    public void setCancelEventIfError(BooleanFeature cancelEventIfError) {
        this.cancelEventIfError = cancelEventIfError;
    }
}

