/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.custom.variables.update.group;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.FeatureWithHisOwnEditor;
import com.ssomar.score.features.FeaturesGroup;
import com.ssomar.score.features.custom.variables.update.group.VariableUpdateGroupFeatureEditor;
import com.ssomar.score.features.custom.variables.update.group.VariableUpdateGroupFeatureEditorManager;
import com.ssomar.score.features.custom.variables.update.variable.VariableUpdateFeature;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class VariableUpdateGroupFeature
extends FeatureWithHisOwnEditor<VariableUpdateGroupFeature, VariableUpdateGroupFeature, VariableUpdateGroupFeatureEditor, VariableUpdateGroupFeatureEditorManager>
implements FeaturesGroup<VariableUpdateFeature> {
    private Map<String, VariableUpdateFeature> variablesUpdates;

    public VariableUpdateGroupFeature(FeatureParentInterface parent) {
        super(parent, FeatureSettingsSCore.variablesModification);
        this.reset();
    }

    @Override
    public void reset() {
        this.variablesUpdates = new HashMap<String, VariableUpdateFeature>();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> error = new ArrayList<String>();
        if (config.isConfigurationSection(this.getName())) {
            ConfigurationSection enchantmentsSection = config.getConfigurationSection(this.getName());
            for (String attributeID : enchantmentsSection.getKeys(false)) {
                VariableUpdateFeature attribute = new VariableUpdateFeature((FeatureParentInterface)this, attributeID);
                List<String> subErrors = attribute.load(plugin, enchantmentsSection, isPremiumLoading);
                if (subErrors.size() > 0) {
                    error.addAll(subErrors);
                    continue;
                }
                this.variablesUpdates.put(attributeID, attribute);
            }
        }
        return error;
    }

    @Override
    public void save(ConfigurationSection config) {
        config.set(this.getName(), null);
        ConfigurationSection attributesSection = config.createSection(this.getName());
        for (String enchantmentID : this.variablesUpdates.keySet()) {
            this.variablesUpdates.get(enchantmentID).save(attributesSection);
        }
        if (this.isSavingOnlyIfDiffDefault() && attributesSection.getKeys(false).isEmpty()) {
            config.set(this.getName(), null);
            return;
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public VariableUpdateGroupFeature getValue() {
        return this;
    }

    @Override
    public VariableUpdateGroupFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = "&7&oVariable(s) added: &e" + this.variablesUpdates.size();
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public VariableUpdateFeature getTheChildFeatureClickedParentEditor(String featureClicked) {
        for (VariableUpdateFeature x : this.variablesUpdates.values()) {
            if (!x.isTheFeatureClickedParentEditor(featureClicked)) continue;
            return x;
        }
        return null;
    }

    @Override
    public VariableUpdateGroupFeature clone(FeatureParentInterface newParent) {
        VariableUpdateGroupFeature eF = new VariableUpdateGroupFeature(newParent);
        HashMap<String, VariableUpdateFeature> newVariablesUpdates = new HashMap<String, VariableUpdateFeature>();
        for (String variableID : this.variablesUpdates.keySet()) {
            newVariablesUpdates.put(variableID, this.variablesUpdates.get(variableID).clone(eF));
        }
        eF.setVariablesUpdates(newVariablesUpdates);
        return eF;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        return new ArrayList<FeatureInterface>(this.variablesUpdates.values());
    }

    @Override
    public String getParentInfo() {
        return this.getParent().getParentInfo();
    }

    @Override
    public ConfigurationSection getConfigurationSection() {
        ConfigurationSection section = this.getParent().getConfigurationSection();
        if (section.isConfigurationSection(this.getName())) {
            return section.getConfigurationSection(this.getName());
        }
        return section.createSection(this.getName());
    }

    @Override
    public File getFile() {
        return this.getParent().getFile();
    }

    @Override
    public void reload() {
        for (FeatureInterface feature : this.getParent().getFeatures()) {
            if (!(feature instanceof VariableUpdateGroupFeature)) continue;
            VariableUpdateGroupFeature eF = (VariableUpdateGroupFeature)feature;
            eF.setVariablesUpdates(this.getVariablesUpdates());
            break;
        }
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        this.getParent().openEditor(player);
    }

    @Override
    public void openEditor(@NotNull Player player) {
        VariableUpdateGroupFeatureEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public void createNewFeature(@NotNull Player editor) {
        String baseId = "varUpdt";
        for (int i = 0; i < 1000; ++i) {
            String id = baseId + i;
            if (this.variablesUpdates.containsKey(id)) continue;
            VariableUpdateFeature eF = new VariableUpdateFeature((FeatureParentInterface)this, id);
            this.variablesUpdates.put(id, eF);
            eF.openEditor(editor);
            break;
        }
    }

    @Override
    public void deleteFeature(@NotNull Player editor, VariableUpdateFeature feature) {
        this.variablesUpdates.remove(feature.getId());
    }

    @Generated
    public Map<String, VariableUpdateFeature> getVariablesUpdates() {
        return this.variablesUpdates;
    }

    @Generated
    public void setVariablesUpdates(Map<String, VariableUpdateFeature> variablesUpdates) {
        this.variablesUpdates = variablesUpdates;
    }
}

