/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.editor;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.editor.FeatureEditorInterface;
import com.ssomar.score.features.editor.FeatureNoLanguageChange;
import com.ssomar.score.features.editor.GenericFeatureParentEditorManager;
import com.ssomar.score.menu.GUI;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class GenericFeatureParentEditor
extends FeatureEditorInterface<FeatureParentInterface> {
    private FeatureParentInterface featureParent;

    public GenericFeatureParentEditor(FeatureParentInterface featureParent) {
        super(featureParent.getFeatureSettings(), Math.max(27, (int)Math.ceil(((double)featureParent.getFeatures().size() + 9.0) / 9.0) * 9));
        this.featureParent = featureParent;
        this.load();
    }

    @Override
    public void load() {
        int i = 0;
        for (FeatureInterface feature : this.featureParent.getFeatures()) {
            feature.initAndUpdateItemParentEditor(this, i);
            ++i;
        }
        this.createItem(RED, 1, this.getSize() - 9, GUI.BACK, false, false, new String[0]);
        this.createItem(ORANGE, 1, this.getSize() - 8, GUI.RESET, false, false, "", "&c&oClick here to reset");
        if (!(this.featureParent instanceof FeatureNoLanguageChange)) {
            this.createItem(YELLOW, 1, this.getSize() - 7, GUI.CHANGE_LANGUAGE, false, false, GeneralConfig.getInstance().getAvailableLocales("", "&e&oClick here to change the language"));
        }
        this.createItem(GREEN, 1, this.getSize() - 1, GUI.SAVE, false, false, "", "&a&oClick here to save");
    }

    @Override
    public FeatureParentInterface getParent() {
        return this.featureParent;
    }

    public void click(Player p, ItemStack item, ClickType click) {
        GenericFeatureParentEditorManager.getInstance().clicked(p, item, click);
    }
}

