/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.item.UpdateItemInGUI;
import com.ssomar.score.utils.strings.StringConverter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.ChatColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ChatColorFeature
extends FeatureAbstract<Optional<ChatColor>, ChatColorFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<ChatColor> value;
    private Optional<ChatColor> defaultValue;

    public ChatColorFeature(FeatureParentInterface parent, Optional<ChatColor> defaultValue, FeatureSettingsInterface featureSettings) {
        super(parent, featureSettings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        try {
            ChatColor chatColor = ChatColor.valueOf((String)colorStr);
            this.value = Optional.ofNullable(chatColor);
            FeatureReturnCheckPremium<ChatColor> checkPremium = this.checkPremium("ChatColor", chatColor, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the ChatColor value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> ChatColors available: https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/ChatColor.html");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((ChatColor)((Optional)this.getValue()).get()).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)((ChatColor)((Optional)this.getValue()).get()).name());
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<ChatColor> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public ChatColorFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 1];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 1] = !this.isPremium() && this.isRequirePremium() ? GUI.PREMIUM : GUI.CLICK_HERE_TO_CHANGE;
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        ChatColor finalValue = ((Optional)value).orElse(ChatColor.WHITE);
        this.updateChatColor(finalValue, gui);
    }

    @Override
    public ChatColorFeature clone(FeatureParentInterface newParent) {
        ChatColorFeature clone = new ChatColorFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return true;
        }
        this.updateChatColor(this.nextChatColor(this.getChatColor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        if (!this.isPremium() && this.isRequirePremium()) {
            return true;
        }
        this.updateChatColor(this.prevChatColor(this.getChatColor((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public ChatColor nextChatColor(ChatColor particle) {
        boolean next = false;
        for (ChatColor check : ChatColor.values()) {
            if (check.equals((Object)particle)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return ChatColor.values()[0];
    }

    public ChatColor prevChatColor(ChatColor color) {
        int i = -1;
        int cpt = 0;
        for (ChatColor check : ChatColor.values()) {
            if (check.equals((Object)color)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return ChatColor.values()[ChatColor.values().length - 1];
        }
        return ChatColor.values()[cpt - 1];
    }

    public void updateChatColor(ChatColor color, GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        this.value = Optional.of(color);
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, 2);
        boolean find = false;
        for (ChatColor check : ChatColor.values()) {
            if (color.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + color.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (ChatColor check : ChatColor.values()) {
            if (lore.size() == 17) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        UpdateItemInGUI.updateItemInGUI(gui, this.getEditorName(), meta.getDisplayName(), lore, item.getType());
    }

    public ChatColor getChatColor(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return ChatColor.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    @Generated
    public Optional<ChatColor> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<ChatColor> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<ChatColor> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

