/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.features.types;

import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.editor.NewGUIManager;
import com.ssomar.score.features.FeatureAbstract;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureRequireOnlyClicksInEditor;
import com.ssomar.score.features.FeatureReturnCheckPremium;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.strings.StringConverter;
import io.papermc.paper.datacomponent.item.consumable.ItemUseAnimation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.TreeMap;
import lombok.Generated;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUseAnimationFeature
extends FeatureAbstract<Optional<ItemUseAnimation>, ItemUseAnimationFeature>
implements FeatureRequireOnlyClicksInEditor {
    private Optional<ItemUseAnimation> value;
    private Optional<ItemUseAnimation> defaultValue;

    public ItemUseAnimationFeature(FeatureParentInterface parent, Optional<ItemUseAnimation> defaultValue, FeatureSettingsInterface settings) {
        super(parent, settings);
        this.defaultValue = defaultValue;
        this.value = Optional.empty();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        String colorStr = config.getString(this.getName(), "NULL").toUpperCase();
        if (colorStr.equals("NULL")) {
            if (this.defaultValue.isPresent()) {
                this.value = this.defaultValue;
            } else {
                errors.add("&cERROR, Couldn't load the ItemUseAnimation value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> BLOCK, BOW, BRUSH, BUNDLE, CROSSBOW, DRINK, EAT, NONE, SPEAR, SPYGLASS, TOOT_HORN (https://jd.papermc.io/paper/1.21.4/io/papermc/paper/datacomponent/item/consumable/ItemUseAnimation.html)");
                this.value = Optional.empty();
            }
            return errors;
        }
        try {
            ItemUseAnimation attributeSlot = ItemUseAnimation.valueOf((String)colorStr.toUpperCase());
            this.value = Optional.ofNullable(attributeSlot);
            FeatureReturnCheckPremium<ItemUseAnimation> checkPremium = this.checkPremium("ItemUseAnimation", attributeSlot, this.defaultValue, isPremiumLoading);
            if (checkPremium.isHasError()) {
                this.value = Optional.of(checkPremium.getNewValue());
            }
        }
        catch (Exception e) {
            errors.add("&cERROR, Couldn't load the ItemUseAnimation value of " + this.getName() + " from config, value: " + colorStr + " &7&o" + this.getParent().getParentInfo() + " &6>> BLOCK, BOW, BRUSH, BUNDLE, CROSSBOW, DRINK, EAT, NONE, SPEAR, SPYGLASS, TOOT_HORN (https://jd.papermc.io/paper/1.21.4/io/papermc/paper/datacomponent/item/consumable/ItemUseAnimation.html)");
            this.value = Optional.empty();
        }
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        if (((Optional)this.getValue()).isPresent()) {
            if (this.defaultValue.isPresent() && this.isSavingOnlyIfDiffDefault() && ((ItemUseAnimation)((Optional)this.getValue()).get()).equals((Object)this.defaultValue.get())) {
                config.set(this.getName(), null);
                return;
            }
            config.set(this.getName(), (Object)((ItemUseAnimation)((Optional)this.getValue()).get()).name());
        }
        if (GeneralConfig.getInstance().isEnableCommentsInConfig()) {
            config.setComments(this.getName(), StringConverter.decoloredString(Arrays.asList(this.getFeatureSettings().getEditorDescriptionBrut())));
        }
    }

    @Override
    public Optional<ItemUseAnimation> getValue() {
        if (this.value.isPresent()) {
            return this.value;
        }
        return this.defaultValue;
    }

    @Override
    public ItemUseAnimationFeature initItemParentEditor(GUI gui, int slot) {
        String[] finalDescription = new String[this.getEditorDescription().length + 2];
        System.arraycopy(this.getEditorDescription(), 0, finalDescription, 0, this.getEditorDescription().length);
        finalDescription[finalDescription.length - 2] = GUI.CLICK_HERE_TO_CHANGE;
        finalDescription[finalDescription.length - 1] = TM.g(Text.EDITOR_CURRENTLY_NAME);
        gui.createItem(this.getEditorMaterial(), 1, slot, GUI.TITLE_COLOR + this.getEditorName(), false, false, finalDescription);
        return this;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
        Object value = this.getValue();
        ItemUseAnimation finalValue = ((Optional)value).orElse(ItemUseAnimation.EAT);
        this.updateDropType(finalValue, gui);
    }

    @Override
    public ItemUseAnimationFeature clone(FeatureParentInterface newParent) {
        ItemUseAnimationFeature clone = new ItemUseAnimationFeature(newParent, this.getDefaultValue(), this.getFeatureSettings());
        clone.value = this.value;
        return clone;
    }

    @Override
    public void reset() {
        this.value = this.defaultValue;
    }

    @Override
    public void clickParentEditor(Player editor, NewGUIManager manager) {
    }

    @Override
    public boolean noShiftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftLeftclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean noShiftRightclicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftLeftClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean shiftRightClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean leftClicked(Player editor, NewGUIManager manager) {
        this.updateDropType(this.nextCreationType(this.getDropType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean rightClicked(Player editor, NewGUIManager manager) {
        this.updateDropType(this.prevCreationType(this.getDropType((GUI)manager.getCache().get(editor))), (GUI)manager.getCache().get(editor));
        return true;
    }

    @Override
    public boolean doubleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    @Override
    public boolean middleClicked(Player editor, NewGUIManager manager) {
        return false;
    }

    public ItemUseAnimation nextCreationType(ItemUseAnimation slot) {
        boolean next = false;
        for (ItemUseAnimation check : this.getSortDropTypes()) {
            if (check.equals((Object)slot)) {
                next = true;
                continue;
            }
            if (!next) continue;
            return check;
        }
        return this.getSortDropTypes().get(0);
    }

    public ItemUseAnimation prevCreationType(ItemUseAnimation slot) {
        int i = -1;
        int cpt = 0;
        for (ItemUseAnimation check : this.getSortDropTypes()) {
            if (check.equals((Object)slot)) {
                i = cpt;
                break;
            }
            ++cpt;
        }
        if (i == 0) {
            return this.getSortDropTypes().get(this.getSortDropTypes().size() - 1);
        }
        return this.getSortDropTypes().get(cpt - 1);
    }

    public void updateDropType(ItemUseAnimation slot, GUI gui) {
        this.value = Optional.of(slot);
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List<String> lore = meta.getLore().subList(0, this.getEditorDescription().length + 2);
        int maxSize = lore.size();
        if ((maxSize += this.getSortDropTypes().size()) > 17) {
            maxSize = 17;
        }
        boolean find = false;
        for (ItemUseAnimation check : this.getSortDropTypes()) {
            if (slot.equals((Object)check)) {
                lore.add(StringConverter.coloredString("&2\u27a4 &a" + slot.name()));
                find = true;
                continue;
            }
            if (!find) continue;
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        for (ItemUseAnimation check : this.getSortDropTypes()) {
            if (lore.size() == maxSize) break;
            lore.add(StringConverter.coloredString("&6\u2726 &e" + check.name()));
        }
        meta.setLore(lore);
        item.setItemMeta(meta);
        for (HumanEntity e : gui.getInv().getViewers()) {
            if (!(e instanceof Player)) continue;
            Player p = (Player)e;
            p.updateInventory();
        }
    }

    public ItemUseAnimation getDropType(GUI gui) {
        ItemStack item = gui.getByIdentifier(this.getEditorName());
        ItemMeta meta = item.getItemMeta();
        List lore = meta.getLore();
        for (String str : lore) {
            if (!str.contains("\u27a4 ")) continue;
            str = StringConverter.decoloredString(str).replaceAll(" Premium", "");
            return ItemUseAnimation.valueOf((String)str.split("\u27a4 ")[1]);
        }
        return null;
    }

    public List<ItemUseAnimation> getSortDropTypes() {
        TreeMap<String, ItemUseAnimation> map = new TreeMap<String, ItemUseAnimation>();
        for (ItemUseAnimation l : ItemUseAnimation.values()) {
            map.put(l.name(), l);
        }
        return new ArrayList<ItemUseAnimation>(map.values());
    }

    @Generated
    public Optional<ItemUseAnimation> getDefaultValue() {
        return this.defaultValue;
    }

    @Generated
    public void setValue(Optional<ItemUseAnimation> value) {
        this.value = value;
    }

    @Generated
    public void setDefaultValue(Optional<ItemUseAnimation> defaultValue) {
        this.defaultValue = defaultValue;
    }
}

