/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.hardness.hardness;

import com.ssomar.score.SCore;
import com.ssomar.score.features.FeatureInterface;
import com.ssomar.score.features.FeatureParentInterface;
import com.ssomar.score.features.FeatureSettingsSCore;
import com.ssomar.score.features.custom.detailedblocks.DetailedBlocks;
import com.ssomar.score.features.custom.detaileditems.DetailedItems;
import com.ssomar.score.features.types.BooleanFeature;
import com.ssomar.score.features.types.IntegerFeature;
import com.ssomar.score.hardness.HardnessModifier;
import com.ssomar.score.hardness.hardness.HardnessEditor;
import com.ssomar.score.hardness.hardness.HardnessEditorManager;
import com.ssomar.score.hardness.hardness.HardnessesEditor;
import com.ssomar.score.hardness.hardness.loader.HardnessLoader;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObjectWithFileEditable;
import com.ssomar.score.sobject.menu.NewSObjectsManagerEditor;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.placeholders.StringPlaceholder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Particle;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class Hardness
extends SObjectWithFileEditable<Hardness, HardnessEditor, HardnessEditorManager>
implements HardnessModifier {
    private BooleanFeature enabled;
    private DetailedBlocks detailedBlocks;
    private DetailedItems detailedItems;
    private IntegerFeature period;
    private BooleanFeature periodInTicks;

    public Hardness(FeatureParentInterface parent, String id, String path) {
        super(SCore.plugin, id, parent, FeatureSettingsSCore.HARDNESS, path, HardnessLoader.getInstance());
        this.reset();
    }

    public Hardness(String id, String path) {
        super(SCore.plugin, id, FeatureSettingsSCore.HARDNESS, path, HardnessLoader.getInstance());
        this.reset();
    }

    @Override
    public List<String> load(SPlugin plugin, ConfigurationSection config, boolean isPremiumLoading) {
        ArrayList<String> errors = new ArrayList<String>();
        errors.addAll(this.enabled.load(plugin, config, isPremiumLoading));
        errors.addAll(this.detailedBlocks.load(plugin, config, isPremiumLoading));
        errors.addAll(this.detailedItems.load(plugin, config, isPremiumLoading));
        errors.addAll(this.period.load(plugin, config, isPremiumLoading));
        errors.addAll(this.periodInTicks.load(plugin, config, isPremiumLoading));
        return errors;
    }

    @Override
    public void save(ConfigurationSection config) {
        for (String s : config.getKeys(false)) {
            config.set(s, null);
        }
        for (FeatureInterface feature : this.getFeatures()) {
            feature.save(config);
        }
    }

    @Override
    public Hardness getValue() {
        return this;
    }

    @Override
    public Hardness initItemParentEditor(GUI gui, int slot) {
        return null;
    }

    @Override
    public void updateItemParentEditor(GUI gui) {
    }

    @Override
    public void reset() {
        this.enabled = new BooleanFeature(this, false, FeatureSettingsSCore.enabled);
        this.detailedBlocks = new DetailedBlocks(this);
        this.detailedItems = new DetailedItems(this);
        this.period = new IntegerFeature(this, Optional.of(3), FeatureSettingsSCore.period);
        this.periodInTicks = new BooleanFeature(this, false, FeatureSettingsSCore.periodInTicks);
    }

    @Override
    public Hardness clone(FeatureParentInterface newParent) {
        Hardness clone = new Hardness(this, this.getId(), this.getPath());
        clone.setEnabled(this.enabled.clone(clone));
        clone.setDetailedBlocks(this.detailedBlocks.clone(clone));
        clone.setDetailedItems(this.detailedItems.clone(clone));
        clone.setPeriod(this.period.clone(clone));
        clone.setPeriodInTicks(this.periodInTicks.clone(clone));
        return clone;
    }

    @Override
    public List<FeatureInterface> getFeatures() {
        ArrayList<FeatureInterface> features = new ArrayList<FeatureInterface>();
        features.add(this.enabled);
        features.add(this.detailedBlocks);
        features.add(this.detailedItems);
        features.add(this.period);
        features.add(this.periodInTicks);
        return features;
    }

    @Override
    public String getParentInfo() {
        return "Hardness: " + this.getId();
    }

    @Override
    public void reload() {
        if (this.getParent() instanceof Hardness) {
            Hardness sProjectile = (Hardness)this.getParent();
            sProjectile.setEnabled(this.enabled);
            sProjectile.setDetailedBlocks(this.detailedBlocks);
            sProjectile.setDetailedItems(this.detailedItems);
            sProjectile.setPeriod(this.period);
            sProjectile.setPeriodInTicks(this.periodInTicks);
        }
    }

    @Override
    public List<String> getDescription() {
        ArrayList<String> description = new ArrayList<String>();
        description.add("\u00a77ID: \u00a7f" + this.getId());
        description.add("\u00a77Enabled: \u00a7f" + this.enabled.getValue());
        description.add("\u00a77Path: \u00a7f" + this.getPath());
        return description;
    }

    @Override
    public void openBackEditor(@NotNull Player player) {
        NewSObjectsManagerEditor.getInstance().startEditing(player, new HardnessesEditor());
    }

    @Override
    public void openEditor(@NotNull Player player) {
        HardnessEditorManager.getInstance().startEditing(player, this);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.getValue();
    }

    @Override
    public boolean isTriggered(Player player, Block block, ItemStack tool) {
        return this.detailedBlocks.isValid(block, Optional.ofNullable(player), null, new StringPlaceholder()) && this.detailedItems.isValid(tool, Optional.ofNullable(player), null, new StringPlaceholder());
    }

    @Override
    public void breakBlock(Player player, Block block, ItemStack tool) {
        BlockData typeData = block.getType().createBlockData();
        Particle particle = SCore.is1v20v5Plus() ? Particle.BLOCK : Particle.valueOf((String)"BLOCK_CRACK");
        block.getWorld().spawnParticle(particle, block.getLocation().add(0.5, 0.5, 0.5), 25, 0.5, 0.5, 0.5, 1.0, (Object)typeData);
        block.getWorld().playSound(block.getLocation(), block.getBlockData().getSoundGroup().getBreakSound(), 1.0f, 1.0f);
        block.breakNaturally();
    }

    @Override
    public long getPeriod(Player player, Block block, ItemStack tool) {
        return ((Integer)((Optional)this.period.getValue()).get()).intValue();
    }

    @Override
    public boolean isPeriodInTicks() {
        return this.periodInTicks.getValue();
    }

    @Override
    public ItemStack getIconItem() {
        return new ItemStack(GUI.WRITABLE_BOOK);
    }

    @Generated
    public BooleanFeature getEnabled() {
        return this.enabled;
    }

    @Generated
    public DetailedBlocks getDetailedBlocks() {
        return this.detailedBlocks;
    }

    @Generated
    public DetailedItems getDetailedItems() {
        return this.detailedItems;
    }

    @Generated
    public IntegerFeature getPeriod() {
        return this.period;
    }

    @Generated
    public BooleanFeature getPeriodInTicks() {
        return this.periodInTicks;
    }

    @Generated
    public void setEnabled(BooleanFeature enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setDetailedBlocks(DetailedBlocks detailedBlocks) {
        this.detailedBlocks = detailedBlocks;
    }

    @Generated
    public void setDetailedItems(DetailedItems detailedItems) {
        this.detailedItems = detailedItems;
    }

    @Generated
    public void setPeriod(IntegerFeature period) {
        this.period = period;
    }

    @Generated
    public void setPeriodInTicks(BooleanFeature periodInTicks) {
        this.periodInTicks = periodInTicks;
    }
}

