/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.pack.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;

public class HttpRequest {
    private final String request;
    private final Map<String, String> headers;
    private final String[] requestParts;

    public HttpRequest(String request, Map<String, String> headers) {
        this.request = request;
        this.headers = headers;
        this.requestParts = request.split(" ");
    }

    public String getRequestMethod() {
        return this.requestParts[0];
    }

    public String getRequestURI() {
        return this.requestParts[1];
    }

    public String getProtocolVersion() {
        return this.requestParts[2];
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getRequest() {
        return this.request;
    }

    public static HttpRequest parse(ByteBuf buf) throws IOException {
        buf.resetReaderIndex();
        try (ByteBufInputStream stream = new ByteBufInputStream(buf);){
            HttpRequest httpRequest = HttpRequest.parse((InputStream)stream);
            return httpRequest;
        }
    }

    private static HttpRequest parse(InputStream stream) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(stream);){
            HttpRequest httpRequest;
            try (BufferedReader bufferedReader = new BufferedReader(reader);){
                String request = bufferedReader.readLine();
                Map<String, String> headers = HttpRequest.readHeaders(bufferedReader);
                httpRequest = new HttpRequest(request, headers);
            }
            return httpRequest;
        }
    }

    private static Map<String, String> readHeaders(BufferedReader reader) throws IOException {
        HashMap<String, String> headers = new HashMap<String, String>();
        String header = reader.readLine();
        while (header != null && !header.isEmpty()) {
            int split = header.indexOf(58);
            headers.put(header.substring(0, split), header.substring(split + 1).trim());
            header = reader.readLine();
        }
        return headers;
    }
}

