/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.sobject.menu;

import com.ssomar.score.SCore;
import com.ssomar.score.SsomarDev;
import com.ssomar.score.config.GeneralConfig;
import com.ssomar.score.features.FeatureSettingsInterface;
import com.ssomar.score.languages.messages.TM;
import com.ssomar.score.languages.messages.Text;
import com.ssomar.score.menu.GUI;
import com.ssomar.score.sobject.SObject;
import com.ssomar.score.sobject.SObjectEditable;
import com.ssomar.score.sobject.SObjectManager;
import com.ssomar.score.sobject.SObjectWithFileLoader;
import com.ssomar.score.sobject.menu.SObjectsEditorAbstract;
import com.ssomar.score.splugin.SPlugin;
import com.ssomar.score.utils.DynamicMeta;
import com.ssomar.score.utils.itemwriter.ItemKeyWriterReader;
import com.ssomar.score.utils.strings.StringConverter;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.bukkit.Material;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public abstract class SObjectsWithFileEditor<T extends SObject>
extends SObjectsEditorAbstract<T> {
    private String defaultPath;
    private String path;
    private SObjectWithFileLoader loader;
    private boolean dontShowDirectory = false;

    public SObjectsWithFileEditor(SPlugin sPlugin, FeatureSettingsInterface settings, String path, SObjectManager manager, SObjectWithFileLoader loader) {
        super(sPlugin, settings, manager);
        this.defaultPath = path;
        this.path = path;
        this.loader = loader;
        this.load();
    }

    public List<String> getFilesInFolder(String path) {
        ArrayList<String> listFiles = new ArrayList<String>(Arrays.asList(new File(path).list()));
        if (this.dontShowDirectory) {
            for (File fileEntry : new File(path).listFiles()) {
                if (!fileEntry.isDirectory()) continue;
                listFiles.remove(fileEntry.getName());
                listFiles.addAll(this.getFilesInFolder(path + "/" + fileEntry.getName()));
            }
        }
        Collections.sort(listFiles);
        return listFiles;
    }

    @Override
    public void load() {
        this.clearAndSetBackground();
        int i = 0;
        int total = 0;
        Plugin plugin = this.getSPlugin().getPlugin();
        SsomarDev.testMsg(">>>>>>>>>>>>" + plugin.getDataFolder() + this.path, true);
        List<String> listFiles = this.getFilesInFolder(plugin.getDataFolder() + this.path);
        for (String str : listFiles) {
            if ((index - 1) * 27 <= total && total < index * 27) {
                File fileEntry = new File(plugin.getDataFolder() + this.path + "/" + str);
                String fileName = fileEntry.getName();
                if (fileName.contains(".txt")) continue;
                String name = str;
                if (fileEntry.isDirectory()) {
                    Material material = Material.CHEST;
                    if (str.contains("[icon-")) {
                        String[] split = str.split("\\[icon-");
                        name = split[0];
                        try {
                            material = Material.valueOf((String)split[1].split("]")[0].toUpperCase());
                        }
                        catch (Exception e) {
                            material = Material.CHEST;
                        }
                    }
                    ItemStack itemStack = new ItemStack(material);
                    ItemMeta itemMeta = itemStack.getItemMeta();
                    DynamicMeta dynamicMeta = new DynamicMeta(itemMeta);
                    ItemKeyWriterReader.init().writeString(SCore.pluginHolder, itemStack, dynamicMeta, "folderInfo", str);
                    itemStack.setItemMeta(dynamicMeta.getMeta());
                    this.createItem(itemStack, 1, i, TM.g(Text.EDITOR_FOLDER_NAME) + name, false, false, TM.gA(Text.EDITOR_FOLDER_DESCRIPTION));
                } else {
                    if ((!fileName.contains(".yml") || fileName.equals(".yml")) && this.isDeleteButton()) {
                        this.createItem(Material.BARRIER, 1, i, TM.g(Text.EDITOR_INVALID_FILE_NAME) + str, false, false, "", GUI.SHIFT_LEFT_CLICK_TO_REMOVE, TM.g(Text.EDITOR_INVALID_FILE_DESCRIPTION));
                    }
                    String id = fileName.split(".yml")[0];
                    Optional sObjectOpt = this.getManager().getLoadedObjectWithID(id);
                    if (sObjectOpt.isPresent()) {
                        SObject sObject = (SObject)sObjectOpt.get();
                        ItemStack itemS = ((SObjectEditable)((Object)sObject)).getIconItem();
                        ItemMeta meta = itemS.getItemMeta();
                        ItemFlag additionnalFlag = SCore.is1v20v5Plus() ? ItemFlag.HIDE_ADDITIONAL_TOOLTIP : ItemFlag.valueOf((String)"HIDE_POTION_EFFECTS");
                        meta.addItemFlags(new ItemFlag[]{additionnalFlag});
                        meta.addItemFlags(new ItemFlag[]{additionnalFlag});
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
                        if (SCore.is1v17Plus()) {
                            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_DYE});
                        }
                        if (SCore.is1v20Plus()) {
                            meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ARMOR_TRIM});
                        }
                        itemS.setItemMeta(meta);
                        ArrayList<String> desc = new ArrayList<String>();
                        desc.add("");
                        desc.add(GUI.CLICK_HERE_TO_CHANGE);
                        if (this.isGiveButton()) {
                            desc.add(TM.g(Text.EDITOR_GIVE_SHIFT_RIGHT_DESCRIPTION));
                        }
                        if (this.isDeleteButton()) {
                            desc.add(GUI.SHIFT_LEFT_CLICK_TO_REMOVE);
                        }
                        desc.addAll(((SObjectEditable)((Object)sObject)).getDescription());
                        String[] descArray = new String[desc.size()];
                        for (int j = 0; j < desc.size(); ++j) {
                            descArray[j] = ((String)desc.get(j)).length() > 40 ? ((String)desc.get(j)).substring(0, 39) + "..." : (String)desc.get(j);
                        }
                        this.createItem(itemS, 1, i, CREATION_ID + " &e&o" + id, false, false, descArray);
                    } else if (this.getSPlugin().isLotOfWork()) {
                        this.createItem(Material.BARRIER, 1, i, TM.g(Text.EDITOR_INVALID_CONFIGURATION_NAME) + id, false, false, "", TM.g(Text.EDITOR_INVALID_CONFIGURATION_DESCRIPTION), GUI.SHIFT_LEFT_CLICK_TO_REMOVE, TM.g(Text.EDITOR_INVALID_CONFIGURATION_FREELIMIT) + " &7(&e" + this.getSPlugin().getMaxSObjectsLimit() + " " + this.getManager().getObjectName() + "&7)");
                    } else {
                        this.createItem(Material.BARRIER, 1, i, TM.g(Text.EDITOR_INVALID_CONFIGURATION_NAME) + id, false, false, "", TM.g(Text.EDITOR_INVALID_CONFIGURATION_DESCRIPTION), GUI.SHIFT_LEFT_CLICK_TO_REMOVE);
                    }
                }
                ++i;
            }
            ++total;
        }
        if (listFiles.size() > 27 && index * 27 < listFiles.size()) {
            this.createItem(NEXT_PAGE_MAT, 1, 44, NEXT_PAGE, false, false, new String[0]);
        }
        if (index > 1) {
            this.createItem(PREVIOUS_PAGE_MAT, 1, 37, PREVIOUS_PAGE, false, false, new String[0]);
        }
        if (!this.path.equals(this.defaultPath)) {
            this.createItem(RED, 1, 36, BACK, false, false, new String[0]);
        } else {
            this.createItem(RED, 1, 36, EXIT, false, false, new String[0]);
        }
        this.createItem(YELLOW, 1, 39, GUI.CHANGE_LANGUAGE, false, false, GeneralConfig.getInstance().getAvailableLocales("", "&e&oClick here to change the language"));
        String[] desc = new String[2 + TM.gA(Text.EDITOR_PATH_DESCRIPTION).length];
        desc[0] = "";
        desc[1] = TM.g(Text.EDITOR_CURRENTLY_NAME) + " &a" + this.path;
        System.arraycopy(TM.gA(Text.EDITOR_PATH_DESCRIPTION), 0, desc, 2, TM.gA(Text.EDITOR_PATH_DESCRIPTION).length);
        if (this.isPathButton()) {
            this.createItem(Material.ANVIL, 1, 38, TM.g(Text.EDITOR_PATH_NAME), false, false, desc);
        }
        if (this.isNewButton()) {
            this.createItem(GREEN, 1, 40, NEW + " " + this.getManager().getObjectName(), false, false, new String[0]);
        }
        if (this.isDefaultObjectsButton()) {
            if (this.getSPlugin().isLotOfWork()) {
                this.createItem(PURPLE, 1, 43, TM.g(Text.EDITOR_PREMADE_PREMIUM_NAME).replace("%object%", this.getManager().getObjectName()), false, false, new String[0]);
            } else {
                this.createItem(PURPLE, 1, 43, TM.g(Text.EDITOR_PREMADE_PACKS_NAME).replace("%object%", this.getManager().getObjectName()), false, false, new String[0]);
            }
        }
    }

    @Override
    public void goToFolder(String folder) {
        index = 1;
        this.path = this.getCurrentPath() + "/" + StringConverter.decoloredString(folder).trim();
        this.load();
    }

    @Override
    public void goBack() {
        if (!this.path.equals(this.defaultPath)) {
            String[] split = this.getCurrentPath().split("/");
            StringBuilder newPathBuilder = new StringBuilder("/");
            for (int i = 0; i < split.length - 1; ++i) {
                if (i == 0) continue;
                newPathBuilder.append(split[i]).append("/");
            }
            String newPath = newPathBuilder.toString();
            this.path = newPath = newPath.substring(0, newPath.length() - 1);
        }
        this.load();
    }

    @Generated
    public String getDefaultPath() {
        return this.defaultPath;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Override
    @Generated
    public SObjectWithFileLoader getLoader() {
        return this.loader;
    }

    @Generated
    public boolean isDontShowDirectory() {
        return this.dontShowDirectory;
    }

    @Generated
    public void setDefaultPath(String defaultPath) {
        this.defaultPath = defaultPath;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setLoader(SObjectWithFileLoader loader) {
        this.loader = loader;
    }

    @Generated
    public void setDontShowDirectory(boolean dontShowDirectory) {
        this.dontShowDirectory = dontShowDirectory;
    }
}

