/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.usedapi;

import java.util.UUID;
import me.angeschossen.lands.api.LandsIntegration;
import me.angeschossen.lands.api.flags.Flags;
import me.angeschossen.lands.api.land.Area;
import me.angeschossen.lands.api.land.LandWorld;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class LandsIntegrationAPI {
    private final LandsIntegration landsIntegration;

    public LandsIntegrationAPI(Plugin yourPlugin) {
        this.landsIntegration = LandsIntegration.of((Plugin)yourPlugin);
    }

    public boolean playerIsInHisClaim(@NotNull Player p, Location location, boolean acceptWilderness) {
        Area area = this.landsIntegration.getArea(location);
        if (area == null) {
            return acceptWilderness;
        }
        UUID pUUID = p.getUniqueId();
        return area.getOwnerUID().equals(pUUID) || area.isTrusted(pUUID);
    }

    public boolean playerCanBreakClaimBlock(@NotNull UUID pUUID, @NotNull Location location) {
        Player player = Bukkit.getPlayer((UUID)pUUID);
        if (player == null) {
            return true;
        }
        LandWorld world = this.landsIntegration.getWorld(location.getWorld());
        if (world != null) {
            return world.hasFlag(player, location, Material.STONE, Flags.BLOCK_BREAK, false);
        }
        return true;
    }

    public boolean playerCanPlaceClaimBlock(@NotNull UUID pUUID, @NotNull Location location) {
        Area area = this.landsIntegration.getArea(location);
        if (area == null) {
            return true;
        }
        return area.getOwnerUID().equals(pUUID) || area.isTrusted(pUUID);
    }

    public boolean playerCanOpenClaimBlock(@NotNull UUID pUUID, @NotNull Location location) {
        Area area = this.landsIntegration.getArea(location);
        if (area == null) {
            return true;
        }
        return area.getOwnerUID().equals(pUUID) || area.isTrusted(pUUID);
    }
}

