/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.score.utils.placeholders;

import com.ssomar.score.utils.numbers.RomanNumber;

public abstract class PlaceholdersInterface {
    public static boolean isNumeric(String strNum) {
        if (strNum == null) {
            return false;
        }
        try {
            double d = Double.parseDouble(strNum);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static String replaceCalculPlaceholder(String s, String placeholder, String value, boolean isInteger) {
        return PlaceholdersInterface.replaceCalculPlaceholder(s, placeholder, value, "", "", isInteger, false);
    }

    public static String replaceCalculPlaceholder(String s, String placeholder, String value, String optionalTagSurroundValue, String optionalTagEndBeforeSurround, boolean isInteger) {
        return PlaceholdersInterface.replaceCalculPlaceholder(s, placeholder, value, optionalTagSurroundValue, optionalTagEndBeforeSurround, isInteger, false);
    }

    public static String replaceCalculPlaceholder(String s, String placeholder, String value, String optionalTagSurroundValue, String optionalTagEndBeforeSurround, boolean isInteger, boolean convertToRoman) {
        String result = s;
        if (optionalTagSurroundValue == null) {
            optionalTagSurroundValue = "";
        }
        if (optionalTagEndBeforeSurround == null) {
            optionalTagEndBeforeSurround = "";
        }
        if (!PlaceholdersInterface.isNumeric(value)) {
            while (result.contains(placeholder)) {
                result = result.replaceAll(placeholder, optionalTagSurroundValue + value + optionalTagEndBeforeSurround + optionalTagSurroundValue);
            }
            return result;
        }
        if (result.contains(placeholder)) {
            StringBuilder sb;
            String suit;
            while (result.contains(placeholder + "+")) {
                suit = result.split(placeholder + "\\+")[1];
                sb = new StringBuilder();
                for (char c : suit.toCharArray()) {
                    if ((c < '0' || c > '9') && c != '.') break;
                    sb.append(c);
                }
                if (PlaceholdersInterface.isNumeric(sb.toString())) {
                    double d = Double.parseDouble(sb.toString()) + Double.parseDouble(value);
                    String finalValue = String.valueOf(d);
                    if (isInteger) {
                        finalValue = String.valueOf((int)d);
                    }
                    if (convertToRoman) {
                        finalValue = RomanNumber.toRoman((int)d);
                    }
                    result = result.replaceFirst(placeholder + "\\+" + sb, optionalTagSurroundValue + finalValue + optionalTagEndBeforeSurround + optionalTagSurroundValue);
                    continue;
                }
                result = result.replaceFirst(placeholder + "\\+" + sb, optionalTagSurroundValue + value + optionalTagEndBeforeSurround + optionalTagSurroundValue);
            }
            while (result.contains(placeholder + "-")) {
                suit = result.split(placeholder + "-")[1];
                sb = new StringBuilder();
                for (char c : suit.toCharArray()) {
                    if ((c < '0' || c > '9') && c != '.') break;
                    sb.append(c);
                }
                if (PlaceholdersInterface.isNumeric(sb.toString())) {
                    double d = Double.parseDouble(value) - Double.parseDouble(sb.toString());
                    String finalValue = String.valueOf(d);
                    if (isInteger) {
                        finalValue = String.valueOf((int)d);
                    }
                    if (convertToRoman) {
                        finalValue = RomanNumber.toRoman((int)d);
                    }
                    result = result.replaceFirst(placeholder + "-" + sb, optionalTagSurroundValue + finalValue + optionalTagEndBeforeSurround + optionalTagSurroundValue);
                    continue;
                }
                result = result.replaceFirst(placeholder + "-" + sb, optionalTagSurroundValue + value + optionalTagEndBeforeSurround + optionalTagSurroundValue);
            }
            while (result.contains(placeholder)) {
                if (convertToRoman) {
                    try {
                        int i = Integer.valueOf(value);
                        result = result.replaceAll(placeholder, optionalTagSurroundValue + RomanNumber.toRoman(i) + optionalTagEndBeforeSurround + optionalTagSurroundValue);
                    }
                    catch (Exception exception) {}
                    continue;
                }
                result = result.replaceAll(placeholder, optionalTagSurroundValue + value + optionalTagEndBeforeSurround + optionalTagSurroundValue);
            }
        }
        return result;
    }
}

