/*
 * Decompiled with CFR 0.152.
 */
package com.ssomar.particles.commands;

import com.ssomar.particles.commands.Shape;
import com.ssomar.particles.commands.XParticle;
import com.ssomar.score.SCore;
import com.ssomar.score.utils.scheduler.ScheduledTask;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ShapesManager {
    private static ShapesManager instance;
    private Map<Entity, List<ScheduledTask>> runningShapes;
    Map<String, Shape> shapes;

    public ShapesManager() {
        instance = this;
        this.shapes = new HashMap<String, Shape>();
        this.runningShapes = new HashMap<Entity, List<ScheduledTask>>();
        this.init();
        Runnable task = () -> {
            Iterator<Entity> iterator = this.runningShapes.keySet().iterator();
            while (iterator.hasNext()) {
                Entity entity = iterator.next();
                if (entity instanceof Player) {
                    if (!((Player)entity).isOnline()) {
                        iterator.remove();
                        continue;
                    }
                    if (!this.endedShapes(entity)) continue;
                    iterator.remove();
                    continue;
                }
                if (!entity.isDead()) continue;
                iterator.remove();
            }
        };
        SCore.schedulerHook.runAsyncRepeatingTask(task, 0L, 200L);
    }

    public void init() {
        Method[] methods;
        ArrayList<String> whitelistedShapes = new ArrayList<String>();
        whitelistedShapes.add("atom");
        whitelistedShapes.add("atomic");
        whitelistedShapes.add("blackSun");
        whitelistedShapes.add("blackhole");
        whitelistedShapes.add("chaoticDoublePendulum");
        whitelistedShapes.add("circle");
        whitelistedShapes.add("circularBeam");
        whitelistedShapes.add("cone");
        whitelistedShapes.add("crescent");
        whitelistedShapes.add("cylinder");
        whitelistedShapes.add("diamond");
        whitelistedShapes.add("dna");
        whitelistedShapes.add("dnaReplication");
        whitelistedShapes.add("ellipse");
        whitelistedShapes.add("explosionWave");
        whitelistedShapes.add("eye");
        whitelistedShapes.add("filledCircle");
        whitelistedShapes.add("heart");
        whitelistedShapes.add("helix");
        whitelistedShapes.add("illuminati");
        whitelistedShapes.add("magicCircles");
        whitelistedShapes.add("meguminExplosion");
        whitelistedShapes.add("polygon");
        whitelistedShapes.add("rainbow");
        whitelistedShapes.add("ring");
        whitelistedShapes.add("sphere");
        whitelistedShapes.add("spikeSphere");
        whitelistedShapes.add("square");
        whitelistedShapes.add("star");
        whitelistedShapes.add("tesseract");
        whitelistedShapes.add("vortex");
        whitelistedShapes.add("infinity");
        for (Method method : methods = XParticle.class.getDeclaredMethods()) {
            if (!whitelistedShapes.contains(method.getName())) continue;
            Shape shape = new Shape(method.getName(), method);
            this.shapes.put(method.getName(), shape);
        }
    }

    public Optional<Shape> getShape(String shapeName) {
        for (String name : this.shapes.keySet()) {
            if (!name.equalsIgnoreCase(shapeName)) continue;
            return Optional.of(this.shapes.get(name));
        }
        return Optional.empty();
    }

    public List<String> getShapesNames() {
        ArrayList<String> shapesNames = new ArrayList<String>();
        for (Shape shape : this.shapes.values()) {
            shapesNames.add(shape.getName());
        }
        return shapesNames;
    }

    public static ShapesManager getInstance() {
        if (instance == null) {
            instance = new ShapesManager();
        }
        return instance;
    }

    public void addRunningShape(Entity player, ScheduledTask task) {
        if (!this.runningShapes.containsKey(player)) {
            this.runningShapes.put(player, new ArrayList());
        }
        this.runningShapes.get(player).add(task);
    }

    public void clearRunningShapes(Entity player) {
        if (this.runningShapes.containsKey(player)) {
            for (ScheduledTask task : this.runningShapes.get(player)) {
                task.cancel();
            }
            this.runningShapes.remove(player);
        }
    }

    public boolean endedShapes(Entity player) {
        if (this.runningShapes.containsKey(player)) {
            ArrayList<ScheduledTask> shapesStillRunning = new ArrayList<ScheduledTask>();
            for (ScheduledTask task : this.runningShapes.get(player)) {
                if (task == null || task.isCancelled()) continue;
                shapesStillRunning.add(task);
            }
            if (!shapesStillRunning.isEmpty()) {
                this.runningShapes.put(player, shapesStillRunning);
                return false;
            }
        }
        return true;
    }
}

